/*
 * Decompiled with CFR 0.152.
 */
package com.aaronhowser1.dymm.shade.net.thesilkminer.mc.boson.api.loader;

import com.aaronhowser1.dymm.shade.net.thesilkminer.kotlin.bridge.Unit;
import com.aaronhowser1.dymm.shade.net.thesilkminer.mc.boson.api.id.NameSpacedString;
import com.aaronhowser1.dymm.shade.net.thesilkminer.mc.boson.api.loader.LoadingPhase;
import com.aaronhowser1.dymm.shade.net.thesilkminer.mc.boson.api.loader.Location;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public interface ProgressVisitor {
    @Nonnull
    public Unit beginVisit();

    @Nonnull
    public Unit visitPhases(int var1);

    @Nonnull
    public Unit visitPhase(@Nonnull LoadingPhase<?> var1);

    @Nonnull
    public Unit visitItemsTotal(int var1);

    @Nonnull
    public Unit visitLocation(@Nonnull Location var1, boolean var2);

    @Nonnull
    public Unit visitItems(int var1);

    @Nonnull
    public Unit visitItem(@Nonnull NameSpacedString var1);

    @Nonnull
    public Unit endVisit();

    @Nonnull
    default public ProgressVisitor chain(@Nonnull ProgressVisitor other) {
        final class ChainingProgressVisitor
        implements ProgressVisitor {
            private final List<ProgressVisitor> visitors = new ArrayList<ProgressVisitor>();

            ChainingProgressVisitor(ProgressVisitor first) {
                this.visitors.add(first);
            }

            @Override
            @Nonnull
            public Unit beginVisit() {
                this.visitors.forEach(ProgressVisitor::beginVisit);
                return Unit.UNIT;
            }

            @Override
            @Nonnull
            public Unit visitPhases(int total) {
                this.visitors.forEach(it -> it.visitPhases(total));
                return Unit.UNIT;
            }

            @Override
            @Nonnull
            public Unit visitPhase(@Nonnull LoadingPhase<?> phase) {
                this.visitors.forEach(it -> it.visitPhase(phase));
                return Unit.UNIT;
            }

            @Override
            @Nonnull
            public Unit visitItemsTotal(int total) {
                this.visitors.forEach(it -> it.visitItemsTotal(total));
                return Unit.UNIT;
            }

            @Override
            @Nonnull
            public Unit visitLocation(@Nonnull Location location, boolean isDirectory) {
                this.visitors.forEach(it -> it.visitLocation(location, isDirectory));
                return Unit.UNIT;
            }

            @Override
            @Nonnull
            public Unit visitItems(int amount) {
                this.visitors.forEach(it -> it.visitItems(amount));
                return Unit.UNIT;
            }

            @Override
            @Nonnull
            public Unit visitItem(@Nonnull NameSpacedString name) {
                this.visitors.forEach(it -> it.visitItem(name));
                return Unit.UNIT;
            }

            @Override
            @Nonnull
            public Unit endVisit() {
                this.visitors.forEach(ProgressVisitor::endVisit);
                return Unit.UNIT;
            }

            @Override
            @Nonnull
            public ProgressVisitor chain(@Nonnull ProgressVisitor other) {
                this.visitors.add(other);
                return this;
            }
        }
        return new ChainingProgressVisitor(this).chain(other);
    }
}

