/*
 * Decompiled with CFR 0.152.
 */
package com.aaronhowser1.dymm.shade.net.thesilkminer.mc.boson.implementation.loader;

import com.aaronhowser1.dymm.L;
import com.aaronhowser1.dymm.shade.net.thesilkminer.kotlin.bridge.CheckedException;
import com.aaronhowser1.dymm.shade.net.thesilkminer.kotlin.bridge.Lazy;
import com.aaronhowser1.dymm.shade.net.thesilkminer.kotlin.bridge.Nullable;
import com.aaronhowser1.dymm.shade.net.thesilkminer.kotlin.bridge.Unit;
import com.aaronhowser1.dymm.shade.net.thesilkminer.kotlin.bridge.With;
import com.aaronhowser1.dymm.shade.net.thesilkminer.kotlin.bridge.expression.ElvisExpression;
import com.aaronhowser1.dymm.shade.net.thesilkminer.kotlin.bridge.expression.IfExpression;
import com.aaronhowser1.dymm.shade.net.thesilkminer.kotlin.bridge.expression.TryExpression;
import com.aaronhowser1.dymm.shade.net.thesilkminer.kotlin.bridge.expression.WhenExpression;
import com.aaronhowser1.dymm.shade.net.thesilkminer.kotlin.bridge.reflect.KClass;
import com.aaronhowser1.dymm.shade.net.thesilkminer.kotlin.bridge.reflect.KFunction0;
import com.aaronhowser1.dymm.shade.net.thesilkminer.kotlin.bridge.reflect.KFunction1;
import com.aaronhowser1.dymm.shade.net.thesilkminer.kotlin.bridge.reflect.KFunction2;
import com.aaronhowser1.dymm.shade.net.thesilkminer.mc.boson.api.id.NameSpacedString;
import com.aaronhowser1.dymm.shade.net.thesilkminer.mc.boson.api.loader.Context;
import com.aaronhowser1.dymm.shade.net.thesilkminer.mc.boson.api.loader.ContextBuilder;
import com.aaronhowser1.dymm.shade.net.thesilkminer.mc.boson.api.loader.Filter;
import com.aaronhowser1.dymm.shade.net.thesilkminer.mc.boson.api.loader.IdentifierBuilder;
import com.aaronhowser1.dymm.shade.net.thesilkminer.mc.boson.api.loader.Loader;
import com.aaronhowser1.dymm.shade.net.thesilkminer.mc.boson.api.loader.LoaderBuilder;
import com.aaronhowser1.dymm.shade.net.thesilkminer.mc.boson.api.loader.LoadingPhase;
import com.aaronhowser1.dymm.shade.net.thesilkminer.mc.boson.api.loader.Location;
import com.aaronhowser1.dymm.shade.net.thesilkminer.mc.boson.api.loader.Locator;
import com.aaronhowser1.dymm.shade.net.thesilkminer.mc.boson.api.loader.Preprocessor;
import com.aaronhowser1.dymm.shade.net.thesilkminer.mc.boson.api.loader.Processor;
import com.aaronhowser1.dymm.shade.net.thesilkminer.mc.boson.api.loader.ProgressVisitor;
import com.google.common.collect.ImmutableList;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public final class BosonLoader
implements Loader {
    private final Lazy<L> l;
    private final String name;
    private final List<Locator> locators;
    private final Nullable<ContextBuilder> globalContextBuilder;
    private final IdentifierBuilder identifierBuilder;
    private final Nullable<ProgressVisitor> progressReporter;
    private final List<LoadingPhase<Object>> phases;

    private BosonLoader(@Nonnull LoaderBuilder builder) {
        this.name = ElvisExpression.create(Objects.requireNonNull(Objects.requireNonNull(builder).name()), () -> Integer.toString(this.hashCode())).invoke();
        this.l = Lazy.lazy(() -> L.create("[DYMM Shade] Boson Loader", this.name));
        this.locators = BosonLoader.checkNotEmpty(builder.locators(), () -> "You must specify at least one locator for the loader");
        this.globalContextBuilder = Objects.requireNonNull(builder.contextBuilder());
        this.identifierBuilder = Objects.requireNonNull(builder.identifierBuilder());
        this.progressReporter = Objects.requireNonNull(builder.progressVisitor());
        this.phases = BosonLoader.checkNotEmpty(Objects.requireNonNull(builder.phases()).stream().map(x$0 -> new BosonLoadingPhase((LoaderBuilder.LoadingPhaseBuilder)x$0)).collect(Collectors.toList()), () -> "Unable to create a loader without phases");
        this.l.invoke().info("Loader initialized, waiting for requests");
    }

    @Nonnull
    public static BosonLoader from(@Nonnull LoaderBuilder builder) {
        return new BosonLoader(builder);
    }

    @Nonnull
    private static <T> List<T> checkNotEmpty(@Nonnull List<T> t, @Nonnull KFunction0<String> message) {
        return IfExpression.build(t.isEmpty(), () -> {
            throw new IllegalArgumentException((String)message.invoke());
        }, () -> t).invoke();
    }

    @Override
    @Nonnull
    public Unit load() {
        return With.with(this.l.invoke(), $this$receiver -> {
            $this$receiver.info(String.format("Using loader %s, with %d locators and %d phases", this.name, this.locators.size(), this.phases.size()));
            $this$receiver.debug("Locators: " + this.locators);
            $this$receiver.debug("Identifier builder: " + this.identifierBuilder);
            $this$receiver.debug("Progress visitor: " + this.progressReporter);
            return TryExpression.create(this::doLoading, ImmutableList.of(TryExpression.CatchClause.create(KClass.get(Exception.class), it -> {
                throw new LoaderException("An exception has occurred while attempting to load with loader '" + this.name + "'", (Throwable)it);
            }))).invoke();
        });
    }

    @Nonnull
    private Unit doLoading() {
        return TryExpression.create(() -> {
            this.l.invoke().info("Loading process has started");
            this.progressReporter.ifPresent(ProgressVisitor::beginVisit);
            this.l.invoke().debug("Creating global context for Loader");
            Nullable<Context> globalContext = this.globalContextBuilder.ifPresent(it -> it.buildContext(Nullable.get(null), new Object[0]));
            this.progressReporter.ifPresent(it -> it.visitPhases(this.phases.size()));
            BosonLoader.forEachIndexed(this.phases, (index, phase) -> {
                this.l.invoke().info("Beginning phase " + index + ": " + phase.getName());
                TryExpression.create(() -> this.attemptPhase((LoadingPhase<Object>)phase, globalContext), ImmutableList.of(TryExpression.CatchClause.create(KClass.get(Exception.class), e -> {
                    throw new PhaseException("Unable to reach end of phase " + index + " '" + phase.getName() + "' cleanly due to an error", (Throwable)e);
                }))).invoke();
                this.l.invoke().info("Reached end of phase " + phase.getName() + " successfully");
                return Unit.UNIT;
            });
            this.l.invoke().info("Cleaning up loader resources");
            this.locators.forEach(Locator::clean);
            this.l.invoke().info("Loading process completed");
            return ElvisExpression.create(this.progressReporter.ifPresent(ProgressVisitor::endVisit), () -> Unit.UNIT).invoke();
        }, ImmutableList.of(TryExpression.CatchClause.create(KClass.get(Exception.class), it -> {
            throw new LoaderException(ElvisExpression.create(Nullable.get(it.getMessage()), () -> "null").invoke(), (Throwable)it);
        }))).invoke();
    }

    @Nonnull
    private Unit attemptPhase(@Nonnull LoadingPhase<Object> $this$receiver, @Nonnull Nullable<Context> globalContext) {
        return TryExpression.create(() -> this.goThroughPhase($this$receiver, globalContext), ImmutableList.of(TryExpression.CatchClause.create(KClass.get(Exception.class), e -> {
            throw new PhaseException("An error has occurred while executing phase '" + $this$receiver.getName() + "'", (Throwable)e);
        }))).invoke();
    }

    @Nonnull
    private Unit goThroughPhase(@Nonnull LoadingPhase<Object> $this$receiver, @Nonnull Nullable<Context> globalContext) {
        this.progressReporter.ifPresent(it -> it.visitPhase($this$receiver));
        List<Locator> locators = this.locators;
        List itemsToLoad = locators.stream().flatMap(it -> it.getLocations().stream()).collect(Collectors.toList());
        this.l.invoke().debug("Attempting to load a total of " + itemsToLoad.size() + " items");
        this.progressReporter.ifPresent(it -> it.visitItemsTotal(itemsToLoad.size()));
        Nullable<Context> phaseContext = $this$receiver.getContextBuilder().ifPresent(it -> it.buildContext(Nullable.get($this$receiver), new Object[0]));
        locators.forEach(it -> this.loadThroughLocator((Locator)it, $this$receiver, globalContext, phaseContext));
        return Unit.UNIT;
    }

    @Nonnull
    private Unit loadThroughLocator(@Nonnull Locator $this$receiver, @Nonnull LoadingPhase<Object> phase, @Nonnull Nullable<Context> globalContext, @Nonnull Nullable<Context> phaseContext) {
        this.l.invoke().debug("Attempting to load data through locator " + $this$receiver);
        List<Lazy<Location>> locations = $this$receiver.getLocations();
        this.progressReporter.ifPresent(it -> it.visitItems(locations.size()));
        locations.forEach(it -> this.processLocation((Location)it.invoke(), phase, globalContext, phaseContext));
        return Unit.UNIT;
    }

    @Nonnull
    private Unit processLocation(@Nonnull Location $this$receiver, @Nonnull LoadingPhase<Object> phase, @Nonnull Nullable<Context> globalContext, @Nonnull Nullable<Context> phaseContext) {
        this.progressReporter.ifPresent(it -> it.visitLocation($this$receiver, BosonLoader.isDirectory($this$receiver)));
        return WhenExpression.create(ImmutableList.of(WhenExpression.Case.create(BosonLoader.isDirectory($this$receiver), () -> this.processDirectory($this$receiver, phase, globalContext, phaseContext)), WhenExpression.Case.create(BosonLoader.exists($this$receiver), () -> this.processFile($this$receiver, $this$receiver, phase, globalContext, phaseContext))), () -> {
            this.l.invoke().debug("Skipping location '" + $this$receiver + "' because it doesn't exist: please complain to your nearest cat");
            return Unit.UNIT;
        }).invoke();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    private Unit processDirectory(@Nonnull Location $this$receiver, @Nonnull LoadingPhase<Object> phase, @Nonnull Nullable<Context> globalContext, @Nonnull Nullable<Context> phaseContext) {
        this.l.invoke().debug("Attempting to read all the files inside the directory '" + $this$receiver + "'");
        try (Stream<Path> file = Files.walk($this$receiver.getPath(), new FileVisitOption[0]);){
            file.forEach(it -> this.processFile(BosonLoader.toLocation(it, $this$receiver.getAdditionalContext()), BosonLoader.toLocation($this$receiver.getPath().relativize((Path)it), $this$receiver.getAdditionalContext()), phase, globalContext, phaseContext));
            Unit unit = Unit.UNIT;
            return unit;
        }
        catch (IOException e) {
            throw CheckedException.wrap(e);
        }
    }

    @Nonnull
    private Unit processFile(@Nonnull Location $this$receiver, @Nonnull Location relative, @Nonnull LoadingPhase<Object> phase, @Nonnull Nullable<Context> globalContext, @Nonnull Nullable<Context> phaseContext) {
        this.l.invoke().debug("Attempting to read file '" + $this$receiver + "' (relative: " + relative + ")");
        NameSpacedString name = this.identifierBuilder.makeIdentifier(relative, globalContext, phaseContext);
        return IfExpression.build(BosonLoader.isFiltered($this$receiver, phase), () -> {
            this.l.invoke().debug("Skipping processing of file '" + name + "' because it was filtered");
            return Unit.UNIT;
        }, () -> TryExpression.create(() -> this.process($this$receiver, phase, name, globalContext, phaseContext), ImmutableList.of(TryExpression.CatchClause.create(KClass.get(Exception.class), e -> {
            throw new ProcessingException("An error has occurred while attempting to process location '" + this + "' (name is '" + name + "')", (Throwable)e);
        }))).invoke()).invoke();
    }

    @Nonnull
    private Unit process(@Nonnull Location $this$receiver, @Nonnull LoadingPhase<Object> phase, @Nonnull NameSpacedString name, @Nonnull Nullable<Context> globalContext, @Nonnull Nullable<Context> phaseContext) {
        this.progressReporter.ifPresent(it -> it.visitItem(name));
        this.l.invoke().debug("Reading data from '" + name + "'");
        String content = this.loadContent($this$receiver);
        Nullable<Preprocessor<String, Object>> pre = phase.getPreprocessor();
        return IfExpression.build(pre.unwrap() == null, () -> phase.getProcessor().process(content, name, globalContext, phaseContext), () -> {
            Nullable preContent = ((Preprocessor)pre.unwrap()).preProcessData(content, name, globalContext, phaseContext);
            return IfExpression.build(preContent.unwrap() != null, () -> phase.getProcessor().process(preContent.unwrap(), name, globalContext, phaseContext), () -> Unit.UNIT).invoke();
        }).invoke();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    private String loadContent(@Nonnull Location $this$receiver) {
        try (BufferedReader file = Files.newBufferedReader($this$receiver.getPath());){
            String string = file.lines().collect(Collectors.joining("\n"));
            return string;
        }
        catch (IOException e) {
            throw CheckedException.wrap(e);
        }
    }

    @Nonnull
    private static <T> Unit forEachIndexed(@Nonnull Iterable<T> $this$receiver, @Nonnull KFunction2<Integer, T, Unit> loop) {
        int index = 0;
        for (T item : $this$receiver) {
            loop.invoke(index++, item);
        }
        return Unit.UNIT;
    }

    private static boolean isFiltered(@Nonnull Location $this$receiver, @Nonnull LoadingPhase<?> phase) {
        return BosonLoader.any(phase.getFilters(), it -> !it.canLoad($this$receiver));
    }

    private static <T> boolean any(@Nonnull Iterable<T> $this$receiver, @Nonnull KFunction1<T, Boolean> predicate) {
        if ($this$receiver instanceof Collection && ((Collection)$this$receiver).isEmpty()) {
            return false;
        }
        for (T element : $this$receiver) {
            if (!predicate.invoke(element).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private static boolean exists(@Nonnull Location $this$receiver) {
        return BosonLoader.exists($this$receiver.getPath());
    }

    private static boolean isDirectory(@Nonnull Location $this$receiver) {
        return BosonLoader.isDirectory($this$receiver.getPath());
    }

    private static boolean exists(@Nonnull Path $this$receiver) {
        return Files.exists($this$receiver, new LinkOption[0]);
    }

    private static boolean isDirectory(@Nonnull Path $this$receiver) {
        return Files.isDirectory($this$receiver, new LinkOption[0]);
    }

    @Nonnull
    private static Location toLocation(@Nonnull Path $this$receiver, @Nonnull Nullable<Context> context) {
        return new LocationPathWrapper($this$receiver, context);
    }

    private static final class ProcessingException
    extends RuntimeException {
        ProcessingException(@Nonnull String message, @Nonnull Throwable cause) {
            super(message, cause);
        }
    }

    private static final class PhaseException
    extends RuntimeException {
        PhaseException(@Nonnull String message, @Nonnull Throwable cause) {
            super(message, cause);
        }
    }

    private static final class LoaderException
    extends RuntimeException {
        LoaderException(@Nonnull String message, @Nonnull Throwable cause) {
            super(message, cause);
        }
    }

    private static final class LocationPathWrapper
    implements Location {
        private final Path path;
        private final Nullable<Context> additionalContext;

        private LocationPathWrapper(@Nonnull Path path, @Nonnull Nullable<Context> additionalContext) {
            this.path = Objects.requireNonNull(path);
            this.additionalContext = Objects.requireNonNull(additionalContext);
        }

        @Override
        @Nonnull
        public Path getPath() {
            return this.path;
        }

        @Override
        @Nonnull
        public Nullable<String> getFriendlyName() {
            return Nullable.get(null);
        }

        @Override
        @Nonnull
        public Nullable<Context> getAdditionalContext() {
            return this.additionalContext;
        }
    }

    private static final class BosonLoadingPhase<T>
    implements LoadingPhase<T> {
        private final String name;
        private final List<Filter> filters;
        private final Nullable<ContextBuilder> contextBuilder;
        private final Nullable<Preprocessor<String, T>> preprocessor;
        private final Processor<T> processor;

        private BosonLoadingPhase(@Nonnull LoaderBuilder.LoadingPhaseBuilder builder) {
            this.name = Objects.requireNonNull(builder.name());
            this.filters = Objects.requireNonNull(builder.filters());
            this.contextBuilder = Objects.requireNonNull(builder.contextBuilder());
            this.preprocessor = Nullable.get(Objects.requireNonNull(builder.preprocessor()).unwrap());
            this.processor = Objects.requireNonNull(builder.processor());
        }

        @Override
        @Nonnull
        public String getName() {
            return this.name;
        }

        @Override
        @Nonnull
        public List<Filter> getFilters() {
            return this.filters;
        }

        @Override
        @Nonnull
        public Nullable<ContextBuilder> getContextBuilder() {
            return this.contextBuilder;
        }

        @Override
        @Nonnull
        public Nullable<Preprocessor<String, T>> getPreprocessor() {
            return this.preprocessor;
        }

        @Override
        @Nonnull
        public Processor<T> getProcessor() {
            return this.processor;
        }
    }
}

