/*
 * Decompiled with CFR 0.152.
 */
package com.aaronhowser1.dymm.shade.net.thesilkminer.mc.boson.prefab.loader.locator;

import com.aaronhowser1.dymm.L;
import com.aaronhowser1.dymm.shade.net.thesilkminer.kotlin.bridge.CheckedException;
import com.aaronhowser1.dymm.shade.net.thesilkminer.kotlin.bridge.Lazy;
import com.aaronhowser1.dymm.shade.net.thesilkminer.kotlin.bridge.Nullable;
import com.aaronhowser1.dymm.shade.net.thesilkminer.kotlin.bridge.Unit;
import com.aaronhowser1.dymm.shade.net.thesilkminer.kotlin.bridge.expression.ElvisExpression;
import com.aaronhowser1.dymm.shade.net.thesilkminer.kotlin.bridge.expression.IfExpression;
import com.aaronhowser1.dymm.shade.net.thesilkminer.kotlin.bridge.expression.TryExpression;
import com.aaronhowser1.dymm.shade.net.thesilkminer.kotlin.bridge.expression.WhenExpression;
import com.aaronhowser1.dymm.shade.net.thesilkminer.kotlin.bridge.reflect.KClass;
import com.aaronhowser1.dymm.shade.net.thesilkminer.mc.boson.api.loader.Location;
import com.aaronhowser1.dymm.shade.net.thesilkminer.mc.boson.api.loader.Locator;
import com.aaronhowser1.dymm.shade.net.thesilkminer.mc.boson.prefab.loader.CCK;
import com.aaronhowser1.dymm.shade.net.thesilkminer.mc.boson.prefab.loader.context.BaseContext;
import com.aaronhowser1.dymm.shade.net.thesilkminer.mc.boson.prefab.loader.location.BaseLocation;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;

public final class OneForAllModContainerLocator
implements Locator {
    private static final L LOG = L.create("[DYMM Shade] Boson", "OneForAllModContainerLocator");
    private static final Lazy<Path> PATH_THAT_DOES_NOT_EXIST = Lazy.lazy(() -> {
        Path path = Paths.get("path.that.does.not.exist.because.is.illegal.in.most.file.systems.and.operating.systems", new String[0]);
        while (Files.exists(path, new LinkOption[0])) {
            path = path.resolve("path.that.does.not.exist.because.is.illegal.in.most.file.systems.and.operating.systems");
        }
        return path;
    });
    private final ModContainer lookupContainer;
    private final String targetDirectory;
    private final Kind kind;
    private final List<Nullable<FileSystem>> systemsStack = new ArrayList<Nullable<FileSystem>>();
    private final Lazy<List<Lazy<Location>>> lazyLocations;

    private OneForAllModContainerLocator(@Nonnull ModContainer lookupContainer, @Nonnull String targetDirectory, @Nonnull Kind kind) {
        this.lookupContainer = Objects.requireNonNull(lookupContainer);
        this.targetDirectory = Objects.requireNonNull(targetDirectory);
        this.kind = Objects.requireNonNull(kind);
        this.lazyLocations = Lazy.lazy(() -> {
            LOG.info("Attempting to load data from target ModContainer '" + this.lookupContainer + "': currently looking in '" + this.targetDirectory + "' with kind " + (Object)((Object)this.kind));
            return Loader.instance().getModList().stream().map(this::findLazyLocation).map(Nullable::unwrap).filter(Objects::nonNull).collect(Collectors.toList());
        });
    }

    @Nonnull
    public static OneForAllModContainerLocator create(@Nonnull ModContainer lookupContainer, @Nonnull String targetDirectory, @Nonnull Kind kind) {
        return new OneForAllModContainerLocator(lookupContainer, targetDirectory, kind);
    }

    @Nonnull
    public static OneForAllModContainerLocator create(@Nonnull ModContainer lookupContainer, @Nonnull String targetDirectory) {
        return OneForAllModContainerLocator.create(lookupContainer, targetDirectory, Kind.DATA);
    }

    @Override
    @Nonnull
    public List<Lazy<Location>> getLocations() {
        return this.lazyLocations.invoke();
    }

    @Nonnull
    private Nullable<Lazy<Location>> findLazyLocation(@Nonnull ModContainer container) {
        String jsonDirectory = this.kind.directoryName + "/" + container.getModId() + "/" + this.targetDirectory;
        File source = this.lookupContainer.getSource();
        class FS {
            private Nullable<FileSystem> fileSystem = Nullable.get(null);

            FS() {
            }
        }
        FS fileSystem = new FS();
        return TryExpression.create(() -> {
            Path root = ElvisExpression.create(WhenExpression.create(ImmutableList.of(WhenExpression.Case.create(source.isFile(), () -> {
                FileSystem fs;
                try {
                    fs = FileSystems.newFileSystem(source.toPath(), null);
                    fileSystem.fileSystem = Nullable.get(fs);
                }
                catch (IOException e) {
                    throw CheckedException.wrap(e);
                }
                return Nullable.get(fs.getPath("/" + jsonDirectory, new String[0]));
            }), WhenExpression.Case.create(source.isDirectory(), () -> Nullable.get(source.toPath().resolve(jsonDirectory))), WhenExpression.Case.create(!source.exists(), () -> {
                LOG.debug("Source '" + source + "' for mod container '" + container + "' doesn't exist, it probably is a Launch Plugin or a JAR mod: skipping");
                return Nullable.get(null);
            })), () -> {
                throw new IllegalStateException("Source '" + source + "' for mod container '" + container + "' is not a file nor a directory: this should be impossible");
            }).invoke(), PATH_THAT_DOES_NOT_EXIST).invoke();
            if (!Files.exists(root, new LinkOption[0])) {
                LOG.debug("No directory found in mod container '" + container + "' that matches the path '" + jsonDirectory + "': will be skipped later on");
            } else {
                LOG.info("Successfully found directory '" + jsonDirectory + "' for mod container '" + container + "': adding it to the list");
            }
            return Nullable.get(Lazy.lazy(() -> {
                BaseContext context = BaseContext.create();
                context.set(CCK.MOD_ID_CONTEXT_KEY.invoke(), container.getModId());
                return BaseLocation.create(root, Nullable.get(container.getName()), Nullable.get(context));
            }));
        }, ImmutableList.of(TryExpression.CatchClause.create(KClass.get(CheckedException.class), (E e) -> {
            LOG.bigWarn("An error has occurred while attempting to identify the directory for the candidate " + container + "\nThe container will now be skipped. The exception and the relevant stack traces are the following:\n\n" + Arrays.stream(e.getStackTrace()).map(StackTraceElement::toString).collect(Collectors.joining("\n")));
            return Nullable.get(null);
        })), () -> {
            this.systemsStack.add(fileSystem.fileSystem);
            return Unit.UNIT;
        }).invoke();
    }

    @Override
    @Nonnull
    public Unit clean() {
        OneForAllModContainerLocator.reversed(this.systemsStack).stream().map(Nullable::unwrap).filter(Objects::nonNull).forEach(it -> {
            try {
                it.close();
            }
            catch (IOException e) {
                throw CheckedException.wrap(e);
            }
        });
        return Locator.super.clean();
    }

    @Nonnull
    private static <T> List<T> reversed(@Nonnull List<T> $this$receiver) {
        return IfExpression.build($this$receiver.size() <= 1, () -> $this$receiver, () -> {
            ArrayList copy = new ArrayList($this$receiver);
            OneForAllModContainerLocator.reverse(copy);
            return copy;
        }).invoke();
    }

    @Nonnull
    private static <T> Unit reverse(@Nonnull List<T> $this$receiver) {
        Collections.reverse($this$receiver);
        return Unit.UNIT;
    }

    public static enum Kind {
        ASSETS("assets"),
        DATA("data");

        private final String directoryName;

        private Kind(String directoryName) {
            this.directoryName = directoryName;
        }
    }
}

