/*
 * Decompiled with CFR 0.152.
 */
package com.aaronhowser1.dymm.shade.net.thesilkminer.mc.boson.prefab.loader.preprocessor;

import com.aaronhowser1.dymm.L;
import com.aaronhowser1.dymm.shade.net.thesilkminer.kotlin.bridge.CheckedException;
import com.aaronhowser1.dymm.shade.net.thesilkminer.kotlin.bridge.Nothing;
import com.aaronhowser1.dymm.shade.net.thesilkminer.kotlin.bridge.Nullable;
import com.aaronhowser1.dymm.shade.net.thesilkminer.kotlin.bridge.With;
import com.aaronhowser1.dymm.shade.net.thesilkminer.kotlin.bridge.expression.IfExpression;
import com.aaronhowser1.dymm.shade.net.thesilkminer.kotlin.bridge.reflect.KClass;
import com.aaronhowser1.dymm.shade.net.thesilkminer.mc.boson.api.id.NameSpacedString;
import com.aaronhowser1.dymm.shade.net.thesilkminer.mc.boson.api.loader.Context;
import com.aaronhowser1.dymm.shade.net.thesilkminer.mc.boson.api.loader.Preprocessor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Objects;
import javax.annotation.Nonnull;

public final class CatchingPreprocessor<T, R>
implements Preprocessor<T, R> {
    private final L logger;
    private final Preprocessor<T, R> preprocessor;

    private CatchingPreprocessor(@Nonnull L logger, @Nonnull Preprocessor<T, R> preprocessor) {
        this.logger = Objects.requireNonNull(logger);
        this.preprocessor = Objects.requireNonNull(preprocessor);
    }

    @Nonnull
    public static Nothing throwException(@Nonnull Exception e) {
        try {
            throw new GoThroughException(e);
        }
        catch (NullPointerException ne) {
            ne.initCause(e);
            throw new GoThroughException(ne);
        }
    }

    @Nonnull
    public static Nothing withCustomMessage(@Nonnull String message, @Nonnull Exception e) {
        try {
            throw new CustomMessageException(message, e);
        }
        catch (NullPointerException ne) {
            try {
                ne.initCause(e);
                throw new CustomMessageException(message, ne);
            }
            catch (NullPointerException nne) {
                nne.initCause(ne);
                throw new GoThroughException(nne);
            }
        }
    }

    @Nonnull
    public static <T, R> CatchingPreprocessor<T, R> create(@Nonnull L logger, @Nonnull Preprocessor<T, R> preprocessor) {
        return new CatchingPreprocessor<T, R>(logger, preprocessor);
    }

    @Override
    @Nonnull
    public Nullable<R> preProcessData(@Nonnull T content, @Nonnull NameSpacedString identifier, @Nonnull Nullable<Context> globalContext, @Nonnull Nullable<Context> phaseContext) {
        try {
            return this.preprocessor.preProcessData(content, identifier, globalContext, phaseContext);
        }
        catch (Exception e) {
            if (e instanceof GoThroughException) {
                throw CheckedException.wrap(((GoThroughException)e).wrapped);
            }
            return With.with(this.logger, $this$receiver -> {
                Nullable<String> errorMessage = CatchingPreprocessor.extractMessage(Nullable.get(IfExpression.build(e instanceof CustomMessageException, () -> ((CustomMessageException)e).wrapped, () -> e).invoke()));
                Nullable<String> exceptionType = KClass.get(IfExpression.build(e instanceof CustomMessageException, () -> ((CustomMessageException)e).wrapped, () -> e).invoke().getClass()).getSimpleName();
                String customMessage = IfExpression.build(e instanceof CustomMessageException, () -> "\n\n" + ((CustomMessageException)e).msg + "\n\n", () -> "").invoke();
                StringWriter stringWriter = new StringWriter();
                e.printStackTrace(new PrintWriter(stringWriter));
                String msgFixedPart = "An error has occurred while attempting to pre-process the file '" + identifier + "'\nError message: " + errorMessage + customMessage + "\nException type: " + exceptionType + "\nName of the file that caused the error: " + identifier;
                $this$receiver.bigError(msgFixedPart + "\n\nThe full stacktrace is in the text that follows:\n" + stringWriter, L.DumpStackBehavior.DO_NOT_DUMP);
                return Nullable.get(null);
            });
        }
    }

    @Nonnull
    private static Nullable<String> extractMessage(@Nonnull Nullable<Throwable> $this$receiver) {
        return IfExpression.build(Objects.isNull($this$receiver.unwrap()), () -> Nullable.get(null), () -> IfExpression.build(Objects.isNull(((Throwable)$this$receiver.unwrap()).getMessage()), () -> Nullable.get(null), () -> Nullable.get(((Throwable)$this$receiver.unwrap()).getMessage())).invoke()).invoke();
    }

    private static final class CustomMessageException
    extends RuntimeException {
        private final String msg;
        private final Exception wrapped;

        private CustomMessageException(@Nonnull String msg, @Nonnull Exception wrapped) {
            this.msg = msg;
            this.wrapped = wrapped;
        }
    }

    private static final class GoThroughException
    extends RuntimeException {
        private final Exception wrapped;

        private GoThroughException(@Nonnull Exception wrapped) {
            this.wrapped = Objects.requireNonNull(wrapped);
        }
    }
}

