/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.common.util.io;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class PathMonitor
implements AutoCloseable {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Executor EXECUTOR = CompletableFuture.delayedExecutor(1L, TimeUnit.SECONDS);
    private final Object locker = new Object();
    private final Consumer<Event> callback;
    @Nullable
    private WatchKey key;
    @Nullable
    private Path watchedPath;
    private boolean paused;
    private final Runnable pollTask = () -> {
        this.tick();
        EXECUTOR.execute(this.pollTask);
    };

    public PathMonitor(Consumer<Event> callback) {
        this.callback = callback;
        this.pollTask.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(Path newFile) {
        Object object = this.locker;
        synchronized (object) {
            try {
                this.close();
                this.watchedPath = newFile;
                this.key = newFile.getParent().register(newFile.getParent().getFileSystem().newWatchService(), StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_CREATE);
            }
            catch (IOException e) {
                this.close();
                LOGGER.error((Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wrap(Runnable action) {
        Object object = this.locker;
        synchronized (object) {
            try {
                this.paused = true;
                action.run();
            }
            finally {
                this.pollEvents();
                this.paused = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WatchEvent<?>> pollEvents() {
        Object object = this.locker;
        synchronized (object) {
            if (this.key == null || !this.key.isValid()) {
                return List.of();
            }
            return this.key.pollEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() {
        Object object = this.locker;
        synchronized (object) {
            for (WatchEvent<?> ev : this.pollEvents()) {
                Object obj;
                if (this.paused || !((obj = ev.context()) instanceof Path)) continue;
                Path p = (Path)obj;
                if (this.watchedPath == null || !this.watchedPath.endsWith(p)) continue;
                WatchEvent.Kind<?> kind = ev.kind();
                if (StandardWatchEventKinds.ENTRY_DELETE.equals(kind)) {
                    this.callback.accept(Event.DELETE);
                    continue;
                }
                if (!StandardWatchEventKinds.ENTRY_MODIFY.equals(kind) && !StandardWatchEventKinds.ENTRY_CREATE.equals(kind)) continue;
                this.callback.accept(Event.MODIFY);
            }
        }
    }

    @Override
    public void close() {
        if (this.key != null) {
            this.pollEvents();
            this.key.cancel();
            this.key = null;
        }
        this.watchedPath = null;
    }

    public static enum Event {
        MODIFY,
        DELETE;

    }
}

