/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.common.util.settings;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.Strictness;
import com.google.gson.stream.JsonWriter;
import com.minelittlepony.common.util.settings.Config;
import com.minelittlepony.common.util.settings.Setting;
import com.minelittlepony.common.util.settings.SettingSerializer;
import com.minelittlepony.common.util.settings.ToStringAdapter;
import com.mojang.util.UUIDTypeAdapter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HeirarchicalJsonConfigAdapter
implements Config.Adapter {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Gson gson;
    public static final HeirarchicalJsonConfigAdapter DEFAULT = new HeirarchicalJsonConfigAdapter(new GsonBuilder());

    public HeirarchicalJsonConfigAdapter(GsonBuilder builder) {
        this.gson = builder.setStrictness(Strictness.LENIENT).setPrettyPrinting().registerTypeHierarchyAdapter(Path.class, new ToStringAdapter<Path>(x$0 -> Paths.get(x$0, new String[0]))).registerTypeAdapter(UUID.class, (Object)new UUIDTypeAdapter()).registerTypeHierarchyAdapter(Setting.class, (Object)new SettingSerializer()).create();
    }

    @Override
    public void save(Config config, Path file) {
        try (BufferedWriter buffer = Files.newBufferedWriter(file, new OpenOption[0]);
             JsonWriter writer = this.gson.newJsonWriter((Writer)buffer);){
            writer.beginObject();
            for (String category : config.categoryNames()) {
                writer.name(category);
                writer.beginObject();
                boolean second = false;
                for (Map.Entry setting : config.getCategory(category)) {
                    for (String comment : ((Setting)setting.getValue()).getComments()) {
                        if (second) {
                            buffer.write(44);
                        }
                        buffer.write(System.lineSeparator());
                        buffer.write("    // " + comment);
                    }
                    writer.name((String)setting.getKey());
                    this.gson.toJson(setting.getValue(), Setting.class, writer);
                    second = true;
                }
                writer.endObject();
            }
            writer.endObject();
        }
        catch (IOException e) {
            LOGGER.warn("Error whilst saving Json config", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(Config config, Path file) {
        block11: {
            try {
                if (!Files.isReadable(file)) break block11;
                try (BufferedReader s = Files.newBufferedReader(file);){
                    ((JsonObject)this.gson.fromJson((Reader)s, JsonObject.class)).entrySet().forEach(entry -> config.getCategoryOrEmpty((String)entry.getKey()).ifPresent(category -> ((JsonElement)entry.getValue()).getAsJsonObject().entrySet().forEach(tuple -> category.getOrEmpty(((String)tuple.getKey()).toLowerCase()).ifPresent(setting -> setting.set(this.gson.getAdapter(setting.getType().token()).fromJsonTree((JsonElement)tuple.getValue()))))));
                }
                catch (JsonParseException | IOException e) {
                    LOGGER.warn("Erorr whilst loading json config", e);
                }
            }
            finally {
                this.save(config, file);
            }
        }
    }
}

