/*
 * Decompiled with CFR 0.152.
 */
package space.arim.libertybans.api;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;

public final class NetworkAddress {
    private final byte[] address;

    private NetworkAddress(byte[] address) {
        this.address = address;
    }

    public static NetworkAddress of(InetAddress address) {
        return new NetworkAddress(address.getAddress());
    }

    public static NetworkAddress of(byte[] address) {
        if (address.length != 4 && address.length != 16) {
            throw new IllegalArgumentException("Bad address length");
        }
        return new NetworkAddress((byte[])address.clone());
    }

    public byte[] getRawAddress() {
        return (byte[])this.address.clone();
    }

    public InetAddress toInetAddress() {
        try {
            return InetAddress.getByAddress(this.address);
        }
        catch (UnknownHostException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.address);
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof NetworkAddress)) {
            return false;
        }
        NetworkAddress other = (NetworkAddress)object;
        return Arrays.equals(this.address, other.address);
    }

    public String toString() {
        return this.toInetAddress().getHostAddress();
    }
}

