/*
 * Decompiled with CFR 0.152.
 */
package space.arim.libertybans.api.punish;

import java.time.Duration;
import java.util.Objects;
import space.arim.libertybans.api.PunishmentType;
import space.arim.libertybans.api.Victim;
import space.arim.libertybans.api.punish.EscalationTrack;
import space.arim.libertybans.api.scope.ServerScope;
import space.arim.libertybans.api.select.SelectionOrderBuilder;

public interface PunishmentDetailsCalculator {
    public CalculationResult compute(EscalationTrack var1, Victim var2, SelectionOrderBuilder var3);

    public record CalculationResult(PunishmentType type, String reason, Duration duration, ServerScope scope) {
        public CalculationResult {
            Objects.requireNonNull(type, "type");
            Objects.requireNonNull(reason, "reason");
            Objects.requireNonNull(duration, "duration");
            Objects.requireNonNull(scope, "scope");
            if (duration.isNegative()) {
                throw new IllegalArgumentException("duration cannot be negative");
            }
            if (type == PunishmentType.KICK && !duration.isZero()) {
                throw new IllegalArgumentException("Kicks cannot be temporary");
            }
        }
    }
}

