/*
 * Decompiled with CFR 0.152.
 */
package space.arim.libertybans.api.select;

import java.time.Instant;
import java.util.Optional;
import space.arim.libertybans.api.Operator;
import space.arim.libertybans.api.PunishmentType;
import space.arim.libertybans.api.punish.EscalationTrack;
import space.arim.libertybans.api.scope.ServerScope;
import space.arim.libertybans.api.select.SelectionBase;
import space.arim.libertybans.api.select.SelectionPredicate;

public interface SelectionBuilderBase<B extends SelectionBuilderBase<B, S>, S extends SelectionBase> {
    default public B type(PunishmentType type) {
        return this.types(SelectionPredicate.matchingOnly(type));
    }

    public B types(SelectionPredicate<PunishmentType> var1);

    default public B operator(Operator operator) {
        return this.operators(SelectionPredicate.matchingOnly(operator));
    }

    public B operators(SelectionPredicate<Operator> var1);

    default public B scope(ServerScope scope) {
        return this.scopes(SelectionPredicate.matchingOnly(scope));
    }

    public B scopes(SelectionPredicate<ServerScope> var1);

    default public B escalationTrack(EscalationTrack escalationTrack) {
        return this.escalationTracks(SelectionPredicate.matchingOnly(Optional.ofNullable(escalationTrack)));
    }

    public B escalationTracks(SelectionPredicate<Optional<EscalationTrack>> var1);

    public B selectActiveOnly(boolean var1);

    default public B selectActiveOnly() {
        return this.selectActiveOnly(true);
    }

    default public B selectAll() {
        return this.selectActiveOnly(false);
    }

    public B skipFirstRetrieved(int var1);

    public B limitToRetrieve(int var1);

    public B seekAfter(Instant var1, long var2);

    public B seekBefore(Instant var1, long var2);

    public S build();
}

