/*
 * Decompiled with CFR 0.152.
 */
package space.arim.libertybans.api.select;

import java.util.Arrays;
import java.util.Set;
import space.arim.libertybans.api.select.AllPredicate;
import space.arim.libertybans.api.select.AnyOfPredicate;
import space.arim.libertybans.api.select.NoneOfPredicate;
import space.arim.libertybans.api.select.SimpleEqualityPredicate;

public abstract class SelectionPredicate<U> {
    public abstract Set<U> acceptedValues();

    public abstract Set<U> rejectedValues();

    public final boolean isSimpleEquality() {
        return this.rejectedValues().isEmpty() && this.acceptedValues().size() == 1;
    }

    public final boolean isNotSimpleEquality() {
        return !this.isSimpleEquality();
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SelectionPredicate)) {
            return false;
        }
        SelectionPredicate that = (SelectionPredicate)o;
        return this.acceptedValues().equals(that.acceptedValues()) && this.rejectedValues().equals(that.rejectedValues());
    }

    public final int hashCode() {
        int result = this.acceptedValues().hashCode();
        result = 31 * result + this.rejectedValues().hashCode();
        return result;
    }

    public static <U> SelectionPredicate<U> matchingAll() {
        return AllPredicate.instance();
    }

    public static <U> SelectionPredicate<U> matchingOnly(U value) {
        return new SimpleEqualityPredicate<U>(value);
    }

    @SafeVarargs
    public static <U> SelectionPredicate<U> matchingAnyOf(U first, U ... extra) {
        if (extra.length == 0) {
            return SelectionPredicate.matchingOnly(first);
        }
        U[] combined = Arrays.copyOf(extra, extra.length + 1);
        combined[extra.length] = first;
        return new AnyOfPredicate<U>(Set.of(combined));
    }

    public static <U> SelectionPredicate<U> matchingAnyOf(Set<U> values) {
        values = Set.copyOf(values);
        return switch (values.size()) {
            case 0 -> throw new IllegalArgumentException("Values must be not be empty");
            case 1 -> SelectionPredicate.matchingOnly(values.iterator().next());
            default -> new AnyOfPredicate<U>(values);
        };
    }

    @SafeVarargs
    public static <U> SelectionPredicate<U> matchingNone(U ... values) {
        return SelectionPredicate.matchingNone(Set.of(values));
    }

    public static <U> SelectionPredicate<U> matchingNone(Set<U> values) {
        return new NoneOfPredicate<U>(values);
    }
}

