/*
 * Decompiled with CFR 0.152.
 */
package space.arim.libertybans.bootstrap;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import space.arim.libertybans.bootstrap.ProtectedLibrary;
import space.arim.libertybans.bootstrap.Repositories;
import space.arim.libertybans.bootstrap.depend.Dependency;
import space.arim.libertybans.bootstrap.depend.DependencyLoaderBuilder;
import space.arim.libertybans.bootstrap.depend.ExistingDependency;
import space.arim.libertybans.bootstrap.depend.ExtractNestedJars;
import space.arim.libertybans.bootstrap.depend.Repository;

public enum DependencyBundle {
    CAFFEINE(Repositories.CENTRAL_REPO, ProtectedLibrary.CAFFEINE),
    JAKARTA(Repositories.CENTRAL_REPO, ProtectedLibrary.JAKARTA_INJECT),
    KYORI(Repositories.CENTRAL_REPO, ProtectedLibrary.KYORI_ADVENTURE, ProtectedLibrary.KYORI_EXAMINATION),
    SELF_IMPLEMENTATION(Repositories.ARIM_AFFERO_GPL3, new ProtectedLibrary[0]),
    SLF4J(Repositories.CENTRAL_REPO, ProtectedLibrary.SLF4J_API, ProtectedLibrary.SLF4J_SIMPLE),
    SNAKEYAML(Repositories.CENTRAL_REPO, ProtectedLibrary.SNAKEYAML);

    private final Repository repository;
    private final ProtectedLibrary[] protectedLibraries;

    private DependencyBundle(Repository repository, ProtectedLibrary ... protectedLibraries) {
        this.repository = repository;
        this.protectedLibraries = protectedLibraries;
    }

    Collection<ProtectedLibrary> protectedLibraries() {
        return List.of(this.protectedLibraries);
    }

    public String toString() {
        return this.name().toLowerCase(Locale.ROOT).replace("_", "-");
    }

    ExistingDependency existingDependency() {
        String jarResourceName = String.valueOf((Object)this) + "-bundle.jar";
        URL jarResource = ((Object)((Object)this)).getClass().getResource("/dependencies/jars/" + jarResourceName);
        if (jarResource == null) {
            throw new IllegalStateException("Cannot find nested jar resource for " + String.valueOf((Object)this));
        }
        return new ExtractNestedJars(jarResource, jarResourceName);
    }

    void prepareToDownload(DependencyLoaderBuilder loader) {
        List<Dependency> dependencies;
        try {
            dependencies = this.readDependencies();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        for (Dependency dependency : dependencies) {
            loader.addDependencyPair(dependency, this.repository);
        }
    }

    private InputStream readResource() throws IOException {
        String resourcePath = "/dependencies/" + String.valueOf((Object)this);
        URL resourceUrl = ((Object)((Object)this)).getClass().getResource(resourcePath);
        Objects.requireNonNull(resourceUrl, "internal error, missing " + resourcePath);
        return resourceUrl.openStream();
    }

    private IllegalArgumentException malformatted(String reason) {
        return new IllegalArgumentException("Dependency file for " + String.valueOf((Object)this) + " is malformatted. Reason: " + reason);
    }

    private List<Dependency> readDependencies() throws IOException {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        ArrayBlockingQueue<String> readDetails = new ArrayBlockingQueue<String>(4);
        try (InputStream inputStream = this.readResource();
             InputStreamReader unbufferedReader = new InputStreamReader(inputStream, StandardCharsets.US_ASCII);
             BufferedReader reader = new BufferedReader(unbufferedReader);){
            String nextLine;
            while ((nextLine = reader.readLine()) != null) {
                if (nextLine.isEmpty()) {
                    dependencies.add(this.dependencyFrom(readDetails));
                    continue;
                }
                if (readDetails.offer(nextLine)) continue;
                throw this.malformatted("Too many details");
            }
        }
        if (!readDetails.isEmpty()) {
            dependencies.add(this.dependencyFrom(readDetails));
        }
        return dependencies;
    }

    private Dependency dependencyFrom(BlockingQueue<String> readDetails) {
        if (readDetails.remainingCapacity() != 0) {
            throw this.malformatted("Lacking details, received only " + String.valueOf(readDetails));
        }
        return Dependency.of((String)readDetails.remove(), (String)readDetails.remove(), (String)readDetails.remove(), (String)readDetails.remove());
    }
}

