/*
 * Decompiled with CFR 0.152.
 */
package space.arim.libertybans.bootstrap;

import space.arim.libertybans.bootstrap.logger.BootstrapLogger;

public enum ProtectedLibrary {
    HSQLDB("HSQLDB", "org.hsqldb", "jdbc.JDBCDriver"),
    MARIADB_CONNECTOR("MariaDB-Connector", "org.mariadb.jdbc", "Driver"),
    PGJDBC("PGJDBC", "org.postgresql", "Driver"),
    HIKARICP("HikariCP", "com.zaxxer.hikari", "HikariConfig"),
    FLYWAY("Flyway", "org.flywaydb", "core.Flyway"),
    JOOQ("JOOQ", "org.jooq", "DSLContext"),
    DAZZLECONF_CORE("DazzleConf-Core", "space.arim.dazzleconf", "ConfigurationFactory"),
    DAZZLECONF_EXT_SNAKEYAML("DazzleConf-SnakeYaml", "space.arim.dazzleconf.ext.snakeyaml", "SnakeYamlConfigurationFactory"),
    SNAKEYAML("SnakeYaml", "org.yaml.snakeyaml", "Yaml"),
    JAKARTA_INJECT("Jakarta-Inject", "jakarta.inject", "Provider"),
    SOLID_INJECTOR("SolidInjector", "space.arim.injector", "Injector"),
    CAFFEINE("Caffeine", "com.github.benmanes.caffeine.cache", "Caffeine"),
    KYORI_ADVENTURE("Kyori-Adventure", "net.kyori.adventure", "audience.Audience"),
    KYORI_EXAMINATION("Kyori-Examination", "net.kyori.examination", "Examinable"),
    SLF4J_API("Slf4j", "org.slf4j", "Logger"),
    SLF4J_SIMPLE("Slf4j-Simple", "org.slf4j.simple", "SimpleLogger");

    private final String libName;
    private final String basePackage;
    private final String sampleClassName;

    private ProtectedLibrary(String libraryName, String basePackage, String sampleClassName) {
        this.libName = libraryName;
        this.basePackage = basePackage;
        this.sampleClassName = sampleClassName;
    }

    String libraryName() {
        return this.libName;
    }

    public String basePackage() {
        return this.basePackage;
    }

    String sampleClass() {
        return this.basePackage + "." + this.sampleClassName;
    }

    boolean detect(ClassLoader expectedClassLoader, BootstrapLogger logger) {
        Class<?> sampleClass;
        try {
            sampleClass = Class.forName(this.sampleClass());
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
        boolean foundInHierarchy = ProtectedLibrary.findClassLoaderInHierarchy(sampleClass.getClassLoader(), expectedClassLoader);
        if (!foundInHierarchy) {
            logger.debug("Class " + this.sampleClass() + " found, but not in classloader hierarchy.");
        }
        return foundInHierarchy;
    }

    private static boolean findClassLoaderInHierarchy(ClassLoader subjectToLookFor, ClassLoader hierarchy) {
        if (subjectToLookFor == hierarchy) {
            return true;
        }
        ClassLoader parent = hierarchy.getParent();
        return parent != null && ProtectedLibrary.findClassLoaderInHierarchy(subjectToLookFor, parent);
    }

    public String toString() {
        return this.libName;
    }
}

