/*
 * Decompiled with CFR 0.152.
 */
package space.arim.libertybans.bootstrap.classload;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicInteger;
import space.arim.libertybans.bootstrap.classload.ClassLoadGuard;
import space.arim.libertybans.bootstrap.logger.BootstrapLogger;

public final class RuntimeExceptionCatcher
implements ClassLoadGuard {
    private final BootstrapLogger logger;
    private final Path reportFolder;
    private final ClassLoadGuard next;
    private final AtomicInteger errorCounter = new AtomicInteger();

    public RuntimeExceptionCatcher(BootstrapLogger logger, Path internalFolder, ClassLoadGuard next) {
        this.logger = Objects.requireNonNull(logger);
        this.reportFolder = internalFolder.resolve("bug-reports");
        this.next = Objects.requireNonNull(next);
        try {
            Files.createDirectories(this.reportFolder, new FileAttribute[0]);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    @Override
    public Class<?> delegateLoadClass(String className, boolean resolve, ClassLoadGuard.Destination destination) throws ClassNotFoundException {
        try {
            return this.next.delegateLoadClass(className, resolve, destination);
        }
        catch (RuntimeException runtimeEx) {
            int errorCount = this.errorCounter.incrementAndGet();
            if ((errorCount & 0xF) == 1) {
                this.logger.error("\n***************************************************************************************\nCaught a " + runtimeEx.getClass().getName() + " during classloading for " + className + " with " + errorCount + " error(s) so far. This bug is highly destabilizing. Please see " + String.valueOf(this.reportFolder) + " for details, and copy and send the report there to the relevant people.\n***************************************************************************************");
                ForkJoinPool.commonPool().execute(() -> {
                    Path writeTo = this.reportFolder.resolve(this.getClass().getName() + "-" + errorCount);
                    try (BufferedWriter writer = Files.newBufferedWriter(writeTo, StandardCharsets.UTF_8, new OpenOption[0]);
                         PrintWriter printer = new PrintWriter(writer);){
                        runtimeEx.printStackTrace(printer);
                    }
                    catch (IOException ex) {
                        runtimeEx.addSuppressed(ex);
                        this.logger.warn("Unable to write bug report to file. Printing it here instead.", runtimeEx);
                    }
                });
            }
            throw new ClassNotFoundException("Unexpected runtime error", runtimeEx);
        }
    }

    public String toString() {
        return "IllegalStateCatcher{reportFolder " + String.valueOf(this.reportFolder) + ", next=" + String.valueOf(this.next) + "}";
    }
}

