/*
 * Decompiled with CFR 0.152.
 */
package space.arim.libertybans.bootstrap.depend;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import space.arim.libertybans.bootstrap.depend.BootstrapException;
import space.arim.libertybans.bootstrap.depend.Dependency;
import space.arim.libertybans.bootstrap.depend.DependencyLoader;
import space.arim.libertybans.bootstrap.depend.DownloadResult;
import space.arim.libertybans.bootstrap.depend.ExistingDependency;
import space.arim.libertybans.bootstrap.depend.JarAttachment;

public final class BootstrapLauncher<J extends JarAttachment> {
    private final J jarAttachment;
    private final DependencyLoader dependencyLoader;
    private final Set<ExistingDependency> existingDependencies;

    public BootstrapLauncher(J jarAttachment, DependencyLoader dependencyLoader, Set<ExistingDependency> existingDependencies) {
        this.jarAttachment = (JarAttachment)Objects.requireNonNull(jarAttachment, "jarAttachment");
        this.dependencyLoader = Objects.requireNonNull(dependencyLoader, "dependencyLoader");
        this.existingDependencies = Set.copyOf(existingDependencies);
    }

    private Set<Path> loadJarPaths(Map<Dependency, DownloadResult> results) {
        HashSet<Path> jarPaths = new HashSet<Path>(results.size(), 1.0f);
        HashSet<BootstrapException> failures = new HashSet<BootstrapException>();
        block11: for (Map.Entry<Dependency, DownloadResult> entry : results.entrySet()) {
            Dependency dependency = entry.getKey();
            DownloadResult result = entry.getValue();
            switch (result.getResultType()) {
                case HASH_MISMATCH: {
                    failures.add(new BootstrapException("Failed to download dependency: " + String.valueOf(dependency) + " . Reason: Hash mismatch, expected " + Dependency.bytesToHex(result.getExpectedHash()) + " but got " + Dependency.bytesToHex(result.getActualHash())));
                    continue block11;
                }
                case ERROR: {
                    failures.add(new BootstrapException("Failed to download dependency: " + String.valueOf(dependency) + " . Reason: Exception", result.getException()));
                    continue block11;
                }
            }
            jarPaths.add(result.getJarFile());
        }
        if (!failures.isEmpty()) {
            if (failures.size() == 1) {
                throw (BootstrapException)failures.iterator().next();
            }
            BootstrapException ex = new BootstrapException("Failed to download dependencies. View and report details.");
            for (BootstrapException failure : failures) {
                ex.addSuppressed(failure);
            }
            throw ex;
        }
        try {
            Path targetDirectory = this.dependencyLoader.getOutputDirectory();
            for (ExistingDependency existingDependency : this.existingDependencies) {
                jarPaths.addAll(existingDependency.onDependencyDownload(targetDirectory));
            }
            try (Stream<Path> stream = Files.list(targetDirectory);){
                stream.filter(file -> !jarPaths.contains(file)).forEach(toDelete -> {
                    try {
                        Files.delete(toDelete);
                    }
                    catch (IOException ex) {
                        throw new UncheckedIOException(ex);
                    }
                });
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        return jarPaths;
    }

    public CompletableFuture<J> load() {
        return ((CompletableFuture)this.dependencyLoader.execute().thenApply(this::loadJarPaths)).thenApply(jarPaths -> {
            jarPaths.forEach(arg_0 -> this.jarAttachment.addJarPath(arg_0));
            return this.jarAttachment;
        });
    }
}

