/*
 * Decompiled with CFR 0.152.
 */
package space.arim.libertybans.bootstrap.depend;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import space.arim.libertybans.bootstrap.depend.Dependency;
import space.arim.libertybans.bootstrap.depend.DependencyDownload;
import space.arim.libertybans.bootstrap.depend.DependencyLoader;
import space.arim.libertybans.bootstrap.depend.DownloadResult;
import space.arim.libertybans.bootstrap.depend.Repository;

class DefaultDependencyLoader
implements DependencyLoader {
    private final Executor executor;
    private final Map<Dependency, Repository> pairs;
    private final Path outputDir;

    DefaultDependencyLoader(Executor executor, Map<Dependency, Repository> pairs, Path outputDir) {
        this.executor = executor;
        this.pairs = Map.copyOf(pairs);
        this.outputDir = outputDir;
    }

    @Override
    public Executor getExecutor() {
        return this.executor;
    }

    @Override
    public Map<Dependency, Repository> getDependencyPairs() {
        return this.pairs;
    }

    @Override
    public Path getOutputDirectory() {
        return this.outputDir;
    }

    private CompletableFuture<DownloadResult> downloadDependency(Dependency dependency, Repository repository) {
        Path outputJar = this.outputDir.resolve(dependency.getFullName() + ".jar");
        if (Files.exists(outputJar, new LinkOption[0])) {
            return CompletableFuture.completedFuture(DownloadResult.success(outputJar));
        }
        return CompletableFuture.supplyAsync(() -> new DependencyDownload(dependency, repository, outputJar).download(), this.executor);
    }

    @Override
    public CompletableFuture<Map<Dependency, DownloadResult>> execute() {
        try {
            Files.createDirectories(this.outputDir, new FileAttribute[0]);
        }
        catch (IOException ex) {
            throw new UncheckedIOException("Cannot create directory " + String.valueOf(this.outputDir), ex);
        }
        HashMap<Dependency, CompletableFuture<DownloadResult>> futures = new HashMap<Dependency, CompletableFuture<DownloadResult>>(this.pairs.size());
        for (Map.Entry<Dependency, Repository> pair : this.pairs.entrySet()) {
            futures.put(pair.getKey(), this.downloadDependency(pair.getKey(), pair.getValue()));
        }
        return CompletableFuture.allOf((CompletableFuture[])futures.values().toArray(CompletableFuture[]::new)).thenApply(ignore -> {
            HashMap<Dependency, DownloadResult> result = new HashMap<Dependency, DownloadResult>(futures.size());
            for (Map.Entry entry : futures.entrySet()) {
                result.put((Dependency)entry.getKey(), (DownloadResult)((CompletableFuture)entry.getValue()).join());
            }
            return Map.copyOf(result);
        });
    }
}

