/*
 * Decompiled with CFR 0.152.
 */
package space.arim.libertybans.bootstrap.depend;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import space.arim.libertybans.bootstrap.depend.ExistingDependency;

public final class ExtractNestedJars
implements ExistingDependency {
    private final URL jarResource;
    private final String intermediateFileName;

    public ExtractNestedJars(URL jarResource, String intermediateFileName) {
        this.jarResource = Objects.requireNonNull(jarResource, "jarResource");
        this.intermediateFileName = Objects.requireNonNull(intermediateFileName, "intermediateFileName");
    }

    @Override
    public Set<Path> onDependencyDownload(Path targetDirectory) throws IOException {
        HashSet<Path> outputPaths = new HashSet<Path>();
        HashMap<String, Path> jarsToExtract = new HashMap<String, Path>();
        try (InputStream resourceInput = this.jarResource.openStream();
             JarInputStream jarResourceInput = new JarInputStream(resourceInput);){
            JarEntry entry;
            while ((entry = jarResourceInput.getNextJarEntry()) != null) {
                String entryName = entry.getName();
                if (!entryName.endsWith(".jar")) continue;
                Path extractTo = targetDirectory.resolve(entryName);
                if (entryName.endsWith("-SNAPSHOT.jar") || Files.notExists(extractTo, new LinkOption[0])) {
                    jarsToExtract.put(entryName, extractTo);
                }
                outputPaths.add(extractTo);
            }
        }
        if (!jarsToExtract.isEmpty()) {
            Path intermediateFile = targetDirectory.resolve(this.intermediateFileName);
            try (InputStream resourceInput = this.jarResource.openStream();){
                Files.copy(resourceInput, intermediateFile, StandardCopyOption.REPLACE_EXISTING);
            }
            try (JarFile intermediatejarFile = new JarFile(intermediateFile.toFile());){
                for (Map.Entry jarToExtract : jarsToExtract.entrySet()) {
                    this.extractNestedJar(intermediatejarFile, (String)jarToExtract.getKey(), (Path)jarToExtract.getValue());
                }
            }
        }
        return outputPaths;
    }

    private void extractNestedJar(JarFile sourceJarFile, String entryName, Path destination) throws IOException {
        JarEntry entry = sourceJarFile.getJarEntry(entryName);
        try (InputStream nestedJarStream = sourceJarFile.getInputStream(entry);){
            Files.copy(nestedJarStream, destination, StandardCopyOption.REPLACE_EXISTING);
        }
    }
}

