/*
 * Decompiled with CFR 0.152.
 */
package space.arim.libertybans.env.spigot.plugin;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import org.bukkit.Server;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import space.arim.libertybans.bootstrap.BaseFoundation;
import space.arim.libertybans.bootstrap.Instantiator;
import space.arim.libertybans.bootstrap.LibertyBansLauncher;
import space.arim.libertybans.bootstrap.LibraryDetection;
import space.arim.libertybans.bootstrap.Payload;
import space.arim.libertybans.bootstrap.Platform;
import space.arim.libertybans.bootstrap.ProtectedLibrary;
import space.arim.libertybans.bootstrap.logger.BootstrapLogger;
import space.arim.libertybans.bootstrap.logger.JulBootstrapLogger;
import space.arim.libertybans.env.spigot.plugin.SpigotCulpritFinder;

public final class SpigotPlugin
extends JavaPlugin {
    private BaseFoundation base;

    public synchronized void onEnable() {
        if (this.base != null) {
            throw new IllegalStateException("Plugin enabled twice?");
        }
        this.base = this.initialize();
    }

    public synchronized void onDisable() {
        BaseFoundation base = this.base;
        this.base = null;
        if (base == null) {
            this.getLogger().warning("LibertyBans wasn't launched; check your log for a startup error");
            return;
        }
        base.shutdown();
    }

    static Platform.Builder detectPlatform(JavaPlugin plugin) {
        Server server = plugin.getServer();
        class AdventureLibraryDetection
        implements LibraryDetection {
            AdventureLibraryDetection() {
            }

            @Override
            public boolean evaluatePresence(BootstrapLogger logger) {
                try {
                    Class<Player> audienceClass = Class.forName("net.kyori.adventure.audience.Audience");
                    return audienceClass.isAssignableFrom(Player.class);
                }
                catch (ClassNotFoundException ex) {
                    return false;
                }
            }
        }
        return Platform.builder(Platform.Category.BUKKIT).nameAndVersion(server.getName(), server.getVersion()).slf4jSupport(LibraryDetection.eitherOf(new LibraryDetection.Slf4jPluginLoggerMethod(plugin), new LibraryDetection.ByClassLoaderScan(ProtectedLibrary.SLF4J_API, JavaPlugin.class.getClassLoader()))).kyoriAdventureSupport(new AdventureLibraryDetection()).snakeYamlProvided(LibraryDetection.enabled());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BaseFoundation initialize() {
        BaseFoundation base;
        ClassLoader launchLoader;
        Payload<SpigotPlugin> payload;
        ExecutorService executor = Executors.newCachedThreadPool();
        try {
            LibertyBansLauncher launcher = new LibertyBansLauncher.Builder().folder(this.getDataFolder().toPath()).logger(new JulBootstrapLogger(this.getLogger())).platform(SpigotPlugin.detectPlatform(this)).executor(executor).culpritFinder(new SpigotCulpritFinder()).build();
            payload = launcher.getPayload(this);
            launchLoader = launcher.attemptLaunch().join();
        }
        finally {
            executor.shutdown();
            assert (executor.isTerminated());
        }
        try {
            base = new Instantiator("space.arim.libertybans.env.spigot.SpigotLauncher", launchLoader).invoke(payload);
        }
        catch (IllegalArgumentException | ReflectiveOperationException | SecurityException ex) {
            this.getLogger().log(Level.WARNING, "Failed to launch LibertyBans", ex);
            return null;
        }
        base.startup();
        return base;
    }
}

