/*
 * Decompiled with CFR 0.152.
 */
package space.arim.libertybans.env.sponge.plugin;

import java.util.Optional;

public enum SpongeVersion {
    API_8(2586),
    API_9(2975),
    API_12(3955),
    API_13(4082);

    private final int dataVersion;

    private SpongeVersion(int dataVersion) {
        this.dataVersion = dataVersion;
    }

    public String display() {
        return this.name().replace('_', ' ');
    }

    public boolean isAtLeast(SpongeVersion other) {
        return this.ordinal() >= other.ordinal();
    }

    boolean hasSnakeYaml() {
        return this == API_8 || this == API_9;
    }

    public static Optional<SpongeVersion> detectVersion(int dataVersion) {
        for (SpongeVersion possible : SpongeVersion.values()) {
            if (possible.dataVersion != dataVersion) continue;
            return Optional.of(possible);
        }
        return Optional.empty();
    }

    public static SpongeVersion latestSupported() {
        SpongeVersion[] allValues = SpongeVersion.values();
        return allValues[allValues.length - 1];
    }
}

