/*
 * Decompiled with CFR 0.152.
 */
package space.arim.libertybans.env.standalone.launcher;

import java.io.Console;
import java.nio.file.Path;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Consumer;
import java.util.logging.Logger;
import space.arim.libertybans.bootstrap.BaseFoundation;
import space.arim.libertybans.bootstrap.Instantiator;
import space.arim.libertybans.bootstrap.LibertyBansLauncher;
import space.arim.libertybans.bootstrap.Payload;
import space.arim.libertybans.bootstrap.Platform;
import space.arim.libertybans.bootstrap.logger.BootstrapLogger;
import space.arim.libertybans.bootstrap.logger.JulBootstrapLogger;

public final class StandaloneApplication {
    private final Path folder;
    private final BootstrapLogger logger;

    public StandaloneApplication(Path folder, BootstrapLogger logger) {
        this.folder = folder;
        this.logger = logger;
    }

    public static void main(String[] args) {
        new StandaloneApplication(Path.of("libertybans", new String[0]), new JulBootstrapLogger(Logger.getLogger(StandaloneApplication.class.getName()))).appStart();
    }

    private void appStart() {
        String command;
        this.logger.info("Starting the standalone instance. Use command 'stop' to stop.");
        BaseFoundation base = this.initialize();
        if (base == null) {
            return;
        }
        Consumer commandDispatch = (Consumer)base.platformAccess();
        Console console = System.console();
        while ((command = console.readLine("> ", new Object[0])) != null && !command.equalsIgnoreCase("stop")) {
            commandDispatch.accept(command);
        }
        base.shutdown();
    }

    private BaseFoundation initialize() {
        BaseFoundation base;
        LibertyBansLauncher launcher = new LibertyBansLauncher.Builder().folder(this.folder).logger(this.logger).platform(Platform.builder(Platform.Category.STANDALONE).nameAndVersion("JVM", Runtime.version().toString())).executor(ForkJoinPool.commonPool()).build();
        Payload<Object> payload = launcher.getPayload(Payload.NO_PLUGIN);
        ClassLoader launchLoader = launcher.attemptLaunch().join();
        try {
            base = new Instantiator("space.arim.libertybans.env.standalone.StandaloneLauncher", launchLoader).invoke(payload);
        }
        catch (IllegalArgumentException | ReflectiveOperationException | SecurityException ex) {
            this.logger.warn("Failed to launch LibertyBans", ex);
            return null;
        }
        base.startup();
        return base;
    }
}

