/*
 * Decompiled with CFR 0.152.
 */
package space.arim.libertybans.env.velocity.plugin;

import com.velocitypowered.api.plugin.PluginContainer;
import com.velocitypowered.api.plugin.PluginDescription;
import com.velocitypowered.api.proxy.ProxyServer;
import java.util.Objects;
import java.util.Optional;
import space.arim.libertybans.bootstrap.CulpritFinder;

final class VelocityCulpritFinder
implements CulpritFinder {
    private final ProxyServer server;

    VelocityCulpritFinder(ProxyServer server) {
        this.server = Objects.requireNonNull(server, "server");
    }

    @Override
    public Optional<String> findCulprit(Class<?> libraryClass) {
        for (PluginContainer plugin : this.server.getPluginManager().getPlugins()) {
            Object pluginInstance = plugin.getInstance().orElse(null);
            if (pluginInstance == null || pluginInstance.getClass().getClassLoader() != libraryClass.getClassLoader()) continue;
            PluginDescription description = plugin.getDescription();
            return Optional.of(description.getId() + " " + description.getVersion().orElse("<No-Version>"));
        }
        return Optional.empty();
    }
}

