/*
 * Decompiled with CFR 0.152.
 */
package space.arim.libertybans.env.velocity.plugin;

import com.google.inject.Inject;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.plugin.Dependency;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.PluginContainer;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.util.ProxyVersion;
import java.nio.file.Path;
import org.slf4j.Logger;
import space.arim.libertybans.bootstrap.BaseFoundation;
import space.arim.libertybans.bootstrap.Instantiator;
import space.arim.libertybans.bootstrap.LibertyBansLauncher;
import space.arim.libertybans.bootstrap.LibraryDetection;
import space.arim.libertybans.bootstrap.Payload;
import space.arim.libertybans.bootstrap.Platform;
import space.arim.libertybans.bootstrap.ProtectedLibrary;
import space.arim.libertybans.env.velocity.plugin.Slf4jBootstrapLogger;
import space.arim.libertybans.env.velocity.plugin.VelocityCulpritFinder;

@Plugin(id="libertybans", name="LibertyBans", version="1.1.1", authors={"Contributors to LibertyBans"}, description="The be-all, end-all of discipline.", url="https://github.com/A248/LibertyBans", dependencies={@Dependency(id="luckperms", optional=true)})
public final class VelocityPlugin {
    private final PluginContainer plugin;
    private final ProxyServer server;
    private final Path folder;
    private final Logger logger;
    private BaseFoundation base;

    @Inject
    public VelocityPlugin(PluginContainer plugin, ProxyServer server, @DataDirectory Path folder, Logger logger) {
        this.plugin = plugin;
        this.server = server;
        this.folder = folder;
        this.logger = logger;
    }

    @Subscribe
    public synchronized void onProxyInitialize(ProxyInitializeEvent evt) {
        if (this.base != null) {
            throw new IllegalStateException("Proxy initialised twice?");
        }
        this.base = this.initialize();
    }

    @Subscribe
    public synchronized void onProxyShutdown(ProxyShutdownEvent evt) {
        BaseFoundation base = this.base;
        this.base = null;
        if (base == null) {
            this.logger.warn("LibertyBans wasn't launched; check your log for a startup error");
            return;
        }
        base.shutdown();
    }

    private BaseFoundation initialize() {
        BaseFoundation base;
        ProxyVersion velocityVersion = this.server.getVersion();
        ClassLoader platformClassLoader = PluginContainer.class.getClassLoader();
        LibertyBansLauncher launcher = new LibertyBansLauncher.Builder().folder(this.folder).logger(new Slf4jBootstrapLogger(this.logger)).platform(Platform.builder(Platform.Category.VELOCITY).nameAndVersion(velocityVersion.getName(), velocityVersion.getVersion()).slf4jSupport(LibraryDetection.enabled()).kyoriAdventureSupport(LibraryDetection.enabled()).snakeYamlProvided(LibraryDetection.enabled()).caffeineProvided(new LibraryDetection.ByClassLoaderScan(ProtectedLibrary.CAFFEINE, platformClassLoader)).jakartaProvided(new LibraryDetection.ByClassLoaderScan(ProtectedLibrary.JAKARTA_INJECT, platformClassLoader))).executor(cmd -> this.server.getScheduler().buildTask((Object)this.plugin, cmd).schedule()).culpritFinder(new VelocityCulpritFinder(this.server)).build();
        Payload<PluginContainer> payload = launcher.getPayload(this.plugin);
        ClassLoader launchLoader = launcher.attemptLaunch().join();
        try {
            base = new Instantiator("space.arim.libertybans.env.velocity.VelocityLauncher", launchLoader).invoke(payload, ProxyServer.class, this.server);
        }
        catch (IllegalArgumentException | ReflectiveOperationException | SecurityException ex) {
            this.logger.warn("Failed to launch LibertyBans", (Throwable)ex);
            return null;
        }
        base.startup();
        return base;
    }
}

