/*
 * Decompiled with CFR 0.152.
 */
package space.arim.omnibus;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.ServiceLoader;
import space.arim.omnibus.DefaultOmnibus;
import space.arim.omnibus.Omnibus;
import space.arim.omnibus.spi.OmnibusDefiner;
import space.arim.omnibus.spi.OmnibusProviderSpi;

public final class OmnibusProvider {
    private static final OmnibusDefiner DEFINER = OmnibusProvider.getDefiner();

    private OmnibusProvider() {
    }

    private static OmnibusDefiner getDefiner() {
        ClassLoader classLoader = OmnibusProvider.class.getClassLoader();
        ServiceLoader<OmnibusProviderSpi> loader = ServiceLoader.load(OmnibusProviderSpi.class, classLoader);
        Iterator<OmnibusProviderSpi> it = loader.iterator();
        if (!it.hasNext()) {
            return new DefaultOmnibusDefiner();
        }
        ArrayList<OmnibusProviderSpi> providers = new ArrayList<OmnibusProviderSpi>();
        do {
            providers.add(it.next());
        } while (it.hasNext());
        providers.sort(new Comparator<OmnibusProviderSpi>(){

            @Override
            public int compare(OmnibusProviderSpi o1, OmnibusProviderSpi o2) {
                return o1.priority() - o2.priority();
            }
        }.reversed());
        return ((OmnibusProviderSpi)providers.get(0)).createDefiner();
    }

    public static Omnibus getOmnibus() {
        Class<?> caller = DEFINER.requiresCallerClass() ? WalkerHolder.WALKER.getCallerClass() : null;
        return DEFINER.getOmnibus(caller);
    }

    private static class DefaultOmnibusDefiner
    implements OmnibusDefiner {
        private final Omnibus instance = new DefaultOmnibus();

        private DefaultOmnibusDefiner() {
        }

        @Override
        public Omnibus getOmnibus(Class<?> callerClass) {
            return this.instance;
        }

        @Override
        public boolean requiresCallerClass() {
            return false;
        }
    }

    private static class WalkerHolder {
        static final StackWalker WALKER = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);

        private WalkerHolder() {
        }
    }
}

