/*
 * Decompiled with CFR 0.152.
 */
package space.arim.omnibus.defaultimpl.events;

import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import space.arim.omnibus.defaultimpl.events.AsynchronousListener;
import space.arim.omnibus.defaultimpl.events.DefaultEventsDriver;
import space.arim.omnibus.defaultimpl.events.EventFire;
import space.arim.omnibus.defaultimpl.events.IdentityListenerWrapper;
import space.arim.omnibus.defaultimpl.events.Listener;
import space.arim.omnibus.defaultimpl.events.ListeningMethodScanner;
import space.arim.omnibus.events.AsyncEvent;
import space.arim.omnibus.events.AsynchronousEventConsumer;
import space.arim.omnibus.events.Event;
import space.arim.omnibus.events.EventBus;
import space.arim.omnibus.events.EventBusDriver;
import space.arim.omnibus.events.EventConsumer;
import space.arim.omnibus.events.RegisteredListener;

public final class DefaultEvents
implements EventBus {
    private final DefaultEventsDriver driver = new DefaultEventsDriver();
    private final ConcurrentMap<IdentityListenerWrapper, Set<Listener<?>>> annotatedListenerObjects = new ConcurrentHashMap();

    @Override
    public EventBusDriver getDriver() {
        return this.driver;
    }

    @Override
    public <E extends Event> void fireEvent(E event) {
        this.driver.fireEvent(event);
    }

    private <E extends AsyncEvent> void fireAsyncEventCommon(E event, CompletableFuture<E> future) {
        Listener<E>[] toInvoke = this.driver.getListenersTo(event);
        EventFire<E> eventFire = new EventFire<E>(toInvoke, event, future);
        eventFire.callAsyncListeners(0);
    }

    @Override
    public <E extends AsyncEvent> CompletableFuture<E> fireAsyncEvent(E event) {
        if (event == null) {
            throw new NullPointerException("event");
        }
        CompletableFuture future = new CompletableFuture();
        this.fireAsyncEventCommon(event, future);
        return future;
    }

    @Override
    public <E extends AsyncEvent> void fireAsyncEventWithoutFuture(E event) {
        if (event == null) {
            throw new NullPointerException("event");
        }
        this.fireAsyncEventCommon(event, null);
    }

    @Override
    public <E extends Event> RegisteredListener registerListener(Class<E> eventClass, byte priority, EventConsumer<? super E> eventConsumer) {
        return this.driver.registerListener(eventClass, priority, eventConsumer);
    }

    @Override
    public <E extends AsyncEvent> RegisteredListener registerListener(Class<E> eventClass, byte priority, AsynchronousEventConsumer<? super E> asyncEventConsumer) {
        AsynchronousListener<? super E> listener = new AsynchronousListener<E>(eventClass, priority, asyncEventConsumer);
        this.driver.registerListener(listener);
        return listener;
    }

    @Override
    public void unregisterListener(RegisteredListener listener) {
        Objects.requireNonNull(listener, "listener");
        if (!(listener instanceof Listener)) {
            return;
        }
        this.driver.unregisterListener((Listener)listener);
    }

    @Override
    public void registerListeningMethods(Object annotatedListener) {
        Objects.requireNonNull(annotatedListener, "annotatedListener");
        Set<Listener<?>> transformedListeners = new ListeningMethodScanner(annotatedListener).scanAndTransformAnnotatedMethods();
        if (transformedListeners.isEmpty()) {
            return;
        }
        IdentityListenerWrapper wrapper = new IdentityListenerWrapper(annotatedListener);
        this.annotatedListenerObjects.compute(wrapper, (w, previousListeners) -> {
            if (previousListeners != null) {
                throw new IllegalStateException("Listener " + wrapper + " is already registered");
            }
            for (Listener transformedListener : transformedListeners) {
                this.driver.registerListener(transformedListener);
            }
            return transformedListeners;
        });
    }

    @Override
    public void unregisterListeningMethods(Object annotatedListener) {
        Objects.requireNonNull(annotatedListener, "annotatedListener");
        IdentityListenerWrapper wrapper = new IdentityListenerWrapper(annotatedListener);
        this.annotatedListenerObjects.computeIfPresent(wrapper, (w, transformedListeners) -> {
            for (Listener transformedListener : transformedListeners) {
                this.driver.unregisterListener(transformedListener);
            }
            return null;
        });
    }
}

