/*
 * Decompiled with CFR 0.152.
 */
package space.arim.omnibus.defaultimpl.events;

import java.lang.invoke.MethodHandle;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import space.arim.omnibus.defaultimpl.events.AccessChecker;
import space.arim.omnibus.defaultimpl.events.AsynchronousListener;
import space.arim.omnibus.defaultimpl.events.InvokingAsynchronousEventConsumer;
import space.arim.omnibus.defaultimpl.events.InvokingEventConsumer;
import space.arim.omnibus.defaultimpl.events.Listener;
import space.arim.omnibus.defaultimpl.events.ListeningMethodValidator;
import space.arim.omnibus.defaultimpl.events.SynchronousListener;
import space.arim.omnibus.events.AsyncEvent;
import space.arim.omnibus.events.Event;
import space.arim.omnibus.events.ListeningMethod;

class ListeningMethodScanner {
    private final Object listener;
    private final Class<?> listenerClass;
    private final AccessChecker accessChecker = new AccessChecker();

    ListeningMethodScanner(Object listener) {
        this.listener = listener;
        this.listenerClass = listener.getClass();
    }

    Set<Listener<?>> scanAndTransformAnnotatedMethods() {
        this.accessChecker.checkClassAccess(this.listenerClass);
        HashSet transformedListeners = new HashSet();
        for (Method method : this.listenerClass.getMethods()) {
            ListeningMethod annotation = method.getAnnotation(ListeningMethod.class);
            if (annotation == null) continue;
            Listener<?> transformedListener = this.transformAnnotatedMethod(method, annotation);
            transformedListeners.add(transformedListener);
        }
        return transformedListeners;
    }

    private Listener<?> transformAnnotatedMethod(Method method, ListeningMethod annotation) {
        Listener transformedListener;
        MethodHandle methodHandle = new ListeningMethodValidator(this.accessChecker, method).validateAndUnreflect();
        Class<?>[] parameterTypes = method.getParameterTypes();
        Class<Event> eventClass = parameterTypes[0].asSubclass(Event.class);
        byte priority = annotation.priority();
        if (parameterTypes.length == 1) {
            transformedListener = new SynchronousListener<Event>(eventClass, priority, new InvokingEventConsumer(this.listener, methodHandle));
        } else {
            Class<AsyncEvent> asyncEventClass = eventClass.asSubclass(AsyncEvent.class);
            transformedListener = new AsynchronousListener<AsyncEvent>(asyncEventClass, priority, new InvokingAsynchronousEventConsumer(this.listener, methodHandle));
        }
        return transformedListener;
    }
}

