/*
 * Decompiled with CFR 0.152.
 */
package space.arim.omnibus.defaultimpl.events;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import space.arim.omnibus.defaultimpl.events.AccessChecker;
import space.arim.omnibus.events.AsyncEvent;
import space.arim.omnibus.events.Event;
import space.arim.omnibus.events.EventFireController;

class ListeningMethodValidator {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private final AccessChecker accessChecker;
    private final Method method;

    ListeningMethodValidator(AccessChecker accessChecker, Method method) {
        this.accessChecker = accessChecker;
        this.method = method;
    }

    MethodHandle validateAndUnreflect() {
        this.validateMethodSignature();
        this.detectCheckedExceptions();
        this.getClass().getModule().addReads(this.method.getDeclaringClass().getModule());
        try {
            return LOOKUP.unreflect(this.method);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalArgumentException("Unable to unreflect " + this.fullyQualifiedMethodName(), ex);
        }
    }

    private void validateMethodSignature() {
        if (this.method.getReturnType() != Void.TYPE) {
            throw this.badAnnotatedMethod("non-void return type");
        }
        int modifiers = this.method.getModifiers();
        if (!Modifier.isPublic(modifiers)) {
            throw this.badAnnotatedMethod("non-public access");
        }
        if (Modifier.isStatic(modifiers) || this.method.isDefault()) {
            throw this.badAnnotatedMethod("method is static or default");
        }
        Class<?>[] parameterTypes = this.method.getParameterTypes();
        if (parameterTypes.length == 0) {
            throw this.badAnnotatedMethod("no parameters");
        }
        if (parameterTypes.length > 2) {
            throw this.badAnnotatedMethod("too many parameters");
        }
        if (!Event.class.isAssignableFrom(parameterTypes[0])) {
            throw this.badAnnotatedMethod("first parameter is not subclass of Event");
        }
        this.accessChecker.checkClassAccess(parameterTypes[0]);
        if (parameterTypes.length == 2) {
            if (parameterTypes[1] != EventFireController.class) {
                throw this.badAnnotatedMethod("second parameter is not EventFireController");
            }
            if (!AsyncEvent.class.isAssignableFrom(parameterTypes[0])) {
                throw this.badAnnotatedMethod("first parameter is not subclass of AsyncEvent");
            }
        }
    }

    private void detectCheckedExceptions() {
        for (Class<?> exception : this.method.getExceptionTypes()) {
            if (Error.class.isAssignableFrom(exception) || RuntimeException.class.isAssignableFrom(exception)) continue;
            throw this.badAnnotatedMethod("declares checked exception " + exception.getName());
        }
    }

    private IllegalArgumentException badAnnotatedMethod(String reason) {
        return new IllegalArgumentException(this.fullyQualifiedMethodName() + " violates @ListeningMethod requirements: " + reason);
    }

    private String fullyQualifiedMethodName() {
        return this.method.getDeclaringClass().getName() + "#" + this.method.getName();
    }
}

