/*
 * Decompiled with CFR 0.152.
 */
package space.arim.omnibus.defaultimpl.registry;

import java.util.Objects;
import java.util.Optional;
import space.arim.omnibus.registry.Registration;
import space.arim.omnibus.registry.ServiceChangeEvent;

class ServiceChangeEventImpl<T>
implements ServiceChangeEvent<T> {
    private final Class<T> service;
    private final Registration<T> previous;
    private final Registration<T> updated;

    ServiceChangeEventImpl(Class<T> service, Registration<T> previous, Registration<T> updated) {
        this.service = service;
        this.previous = previous;
        this.updated = updated;
        assert (previous != null || updated != null) : service;
    }

    @Override
    public Class<T> getService() {
        return this.service;
    }

    @Override
    public Optional<Registration<T>> getPrevious() {
        return Optional.ofNullable(this.previous);
    }

    @Override
    public Optional<Registration<T>> getUpdated() {
        return Optional.ofNullable(this.updated);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceChangeEventImpl that = (ServiceChangeEventImpl)o;
        return this.service.equals(that.service) && Objects.equals(this.previous, that.previous) && Objects.equals(this.updated, that.updated);
    }

    public int hashCode() {
        int result = this.service.hashCode();
        result = 31 * result + (this.previous != null ? this.previous.hashCode() : 0);
        result = 31 * result + (this.updated != null ? this.updated.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ServiceChangeEventImpl{service=" + this.service + ", previous=" + this.previous + ", updated=" + this.updated + "}";
    }
}

