/*
 * Decompiled with CFR 0.152.
 */
package space.arim.omnibus.util;

import java.util.UUID;

public final class UUIDUtil {
    private UUIDUtil() {
    }

    public static String expandShortString(String shortUuid) {
        if (shortUuid.length() != 32) {
            throw new IllegalArgumentException("Short uuid " + shortUuid + " must be of length 32");
        }
        return new StringBuilder().append(shortUuid, 0, 8).append('-').append(shortUuid, 8, 12).append('-').append(shortUuid, 12, 16).append('-').append(shortUuid, 16, 20).append('-').append(shortUuid, 20, 32).toString();
    }

    public static String contractFullString(String fullUuid) {
        if (fullUuid.length() != 36) {
            throw new IllegalArgumentException("Full uuid " + fullUuid + " must be of length 36");
        }
        return new StringBuilder().append(fullUuid, 0, 8).append(fullUuid, 9, 13).append(fullUuid, 14, 18).append(fullUuid, 19, 23).append(fullUuid, 24, 36).toString();
    }

    public static String toShortString(UUID uuid) {
        StringBuilder builder = new StringBuilder();
        UUIDUtil.formatAsHex(uuid.getMostSignificantBits(), builder);
        UUIDUtil.formatAsHex(uuid.getLeastSignificantBits(), builder);
        return builder.toString();
    }

    private static void formatAsHex(long bits, StringBuilder builder) {
        String hex = Long.toHexString(bits);
        int leadingZeroes = 16 - hex.length();
        builder.append("0".repeat(leadingZeroes));
        builder.append(hex);
    }

    public static UUID fromShortString(String shortUuid) {
        if (shortUuid.length() != 32) {
            throw new IllegalArgumentException("Short uuid " + shortUuid + " must be of length 32");
        }
        return new UUID(Long.parseUnsignedLong(shortUuid.substring(0, 16), 16), Long.parseUnsignedLong(shortUuid.substring(16, 32), 16));
    }

    public static byte[] toByteArray(UUID uuid) {
        byte[] result = new byte[16];
        UUIDUtil.toByteArray(uuid, result, 0);
        return result;
    }

    public static void toByteArray(UUID uuid, byte[] byteArray, int offset) {
        int i;
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        for (i = 7; i >= 0; --i) {
            byteArray[offset + i] = (byte)(msb & 0xFFL);
            msb >>= 8;
        }
        for (i = 15; i >= 8; --i) {
            byteArray[offset + i] = (byte)(lsb & 0xFFL);
            lsb >>= 8;
        }
    }

    public static UUID fromByteArray(byte[] byteArray) {
        return new UUID(UUIDUtil.longFromBytes(byteArray[0], byteArray[1], byteArray[2], byteArray[3], byteArray[4], byteArray[5], byteArray[6], byteArray[7]), UUIDUtil.longFromBytes(byteArray[8], byteArray[9], byteArray[10], byteArray[11], byteArray[12], byteArray[13], byteArray[14], byteArray[15]));
    }

    public static UUID fromByteArray(byte[] byteArray, int offset) {
        return new UUID(UUIDUtil.longFromBytes(byteArray[offset], byteArray[offset + 1], byteArray[offset + 2], byteArray[offset + 3], byteArray[offset + 4], byteArray[offset + 5], byteArray[offset + 6], byteArray[offset + 7]), UUIDUtil.longFromBytes(byteArray[offset + 8], byteArray[offset + 9], byteArray[offset + 10], byteArray[offset + 11], byteArray[offset + 12], byteArray[offset + 13], byteArray[offset + 14], byteArray[offset + 15]));
    }

    private static long longFromBytes(byte b1, byte b2, byte b3, byte b4, byte b5, byte b6, byte b7, byte b8) {
        return ((long)b1 & 0xFFL) << 56 | ((long)b2 & 0xFFL) << 48 | ((long)b3 & 0xFFL) << 40 | ((long)b4 & 0xFFL) << 32 | ((long)b5 & 0xFFL) << 24 | ((long)b6 & 0xFFL) << 16 | ((long)b7 & 0xFFL) << 8 | (long)b8 & 0xFFL;
    }
}

