/*
 * Decompiled with CFR 0.152.
 */
package space.arim.omnibus.util.concurrent;

import java.util.function.LongUnaryOperator;
import space.arim.omnibus.util.concurrent.DelayCalculator;

public final class DelayCalculators {
    private DelayCalculators() {
    }

    public static DelayCalculator fixedDelay() {
        return (d, ignore) -> d;
    }

    public static DelayCalculator fixedRate() {
        return DelayCalculators.variableRate(LongUnaryOperator.identity());
    }

    public static DelayCalculator variableRate(LongUnaryOperator rateFunction) {
        return new VariableRateFunction(rateFunction);
    }

    private static class VariableRateFunction
    implements DelayCalculator {
        private final LongUnaryOperator rateFunction;
        private volatile long rate = -1L;
        private volatile long offset = 0L;

        VariableRateFunction(LongUnaryOperator rateFunction) {
            this.rateFunction = rateFunction;
        }

        @Override
        public long calculateNextDelay(long previousDelayNanos, long executionTimeNanos) {
            long rate = this.rate;
            if (rate == -1L) {
                rate = previousDelayNanos;
            }
            if ((rate = this.rateFunction.applyAsLong(rate)) < 0L) {
                return -1L;
            }
            this.rate = rate;
            long offset = this.offset;
            long delay = rate - executionTimeNanos - offset;
            if (delay >= 0L) {
                offset = 0L;
            } else {
                offset = -delay;
                delay = 0L;
            }
            this.offset = offset;
            return delay;
        }

        @Override
        public boolean requiresExecutionTime() {
            return true;
        }
    }
}

