/*
 * Decompiled with CFR 0.152.
 */
package space.arim.omnibus.util.concurrent.impl;

import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import space.arim.omnibus.util.concurrent.CentralisedFuture;
import space.arim.omnibus.util.concurrent.FactoryOfTheFuture;
import space.arim.omnibus.util.concurrent.ReactionStage;

public abstract class AbstractFactoryOfTheFuture
implements FactoryOfTheFuture {
    private static final Executor DEFAULT_EXECUTOR = new CompletableFuture().defaultExecutor();

    public abstract <U> CentralisedFuture<U> newIncompleteFuture();

    @Override
    public void execute(Runnable command) {
        if (command == null) {
            throw new NullPointerException("command");
        }
        DEFAULT_EXECUTOR.execute(command);
    }

    @Override
    public CentralisedFuture<?> runAsync(Runnable command) {
        Objects.requireNonNull(command, "command");
        return this.supplyAsync(() -> {
            command.run();
            return null;
        });
    }

    @Override
    public CentralisedFuture<?> runAsync(Runnable command, Executor executor) {
        Objects.requireNonNull(command, "command");
        return this.supplyAsync(() -> {
            command.run();
            return null;
        }, executor);
    }

    @Override
    public CentralisedFuture<?> runSync(Runnable command) {
        Objects.requireNonNull(command, "command");
        return this.supplySync(() -> {
            command.run();
            return null;
        });
    }

    @Override
    public <T> CentralisedFuture<T> supplyAsync(Supplier<T> supplier) {
        return this.newIncompleteFuture().completeAsync(supplier);
    }

    @Override
    public <T> CentralisedFuture<T> supplyAsync(Supplier<T> supplier, Executor executor) {
        return this.newIncompleteFuture().completeAsync(supplier, executor);
    }

    @Override
    public <T> CentralisedFuture<T> supplySync(Supplier<T> supplier) {
        return this.newIncompleteFuture().completeSync(supplier);
    }

    @Override
    public <T> CentralisedFuture<T> completedFuture(T value) {
        CentralisedFuture result = this.newIncompleteFuture();
        result.complete(value);
        return result;
    }

    @Override
    public <T> ReactionStage<T> completedStage(T value) {
        return this.completedFuture(value).minimalCompletionStage();
    }

    @Override
    public <T> CentralisedFuture<T> failedFuture(Throwable ex) {
        CentralisedFuture result = this.newIncompleteFuture();
        result.completeExceptionally(ex);
        return result;
    }

    @Override
    public <T> ReactionStage<T> failedStage(Throwable ex) {
        return this.failedFuture(ex).minimalCompletionStage();
    }

    private <T> CentralisedFuture<T> copyStage0(CompletionStage<T> completionStage) {
        CentralisedFuture copy = this.newIncompleteFuture();
        completionStage.whenComplete((val, ex) -> {
            if (ex == null) {
                copy.complete(val);
            } else {
                copy.completeExceptionally((Throwable)ex);
            }
        });
        return copy;
    }

    @Override
    public <T> CentralisedFuture<T> copyFuture(CompletableFuture<T> completableFuture) {
        return this.copyStage0(completableFuture);
    }

    @Override
    public <T> ReactionStage<T> copyStage(CompletionStage<T> completionStage) {
        return this.copyStage0(completionStage).minimalCompletionStage();
    }

    @Override
    public CentralisedFuture<?> allOf(CentralisedFuture<?> ... futures) {
        if (futures.length == 0) {
            return this.completedFuture(null);
        }
        return this.copyFuture(CompletableFuture.allOf(futures));
    }

    @Override
    public <T> CentralisedFuture<?> allOf(Collection<? extends CentralisedFuture<T>> futures) {
        return this.allOf((CentralisedFuture[])futures.toArray(CentralisedFuture[]::new));
    }
}

