/*
 * Decompiled with CFR 0.152.
 */
package space.arim.omnibus.util.concurrent.impl;

import java.util.function.Consumer;
import space.arim.omnibus.util.concurrent.DelayCalculator;
import space.arim.omnibus.util.concurrent.ScheduledTask;
import space.arim.omnibus.util.concurrent.impl.RunnableScheduledTask;
import space.arim.omnibus.util.concurrent.impl.SimplifiedEnhancedExecutor;

class RepeatingScheduledTaskImpl
extends RunnableScheduledTask {
    private final SimplifiedEnhancedExecutor executor;
    private final Consumer<? super ScheduledTask> command;
    private final DelayCalculator calculator;
    private volatile State state;

    RepeatingScheduledTaskImpl(SimplifiedEnhancedExecutor executor, Consumer<? super ScheduledTask> command, DelayCalculator calculator) {
        this.executor = executor;
        this.command = command;
        this.calculator = calculator;
    }

    void update(long nextDelay, long currentTime) {
        this.state = new State(nextDelay, currentTime);
    }

    @Override
    long getRunTime() {
        return this.state.runTime;
    }

    @Override
    public void run() {
        if (this.isCancelled()) {
            return;
        }
        long startTime = this.calculator.requiresExecutionTime() ? System.nanoTime() : -1L;
        this.executeAndReschedule(startTime);
    }

    private void executeAndReschedule(long startTime) {
        try {
            this.command.accept(this);
        }
        finally {
            if (!this.isCancelled()) {
                this.reschedule(startTime);
            }
        }
    }

    private void reschedule(long startTime) {
        long currentTime = System.nanoTime();
        long executionTime = this.calculator.requiresExecutionTime() ? currentTime - startTime : -1L;
        long nextDelay = this.calculator.calculateNextDelay(this.state.delay, executionTime);
        if (nextDelay < 0L) {
            this.cancel();
            return;
        }
        this.update(nextDelay, currentTime);
        if (nextDelay == 0L) {
            this.executeAndReschedule(currentTime);
            return;
        }
        if (this.isCancelled()) {
            return;
        }
        this.executor.publishTask(this, nextDelay);
    }

    @Override
    public boolean isRepeating() {
        return true;
    }

    private static class State {
        final long delay;
        final long runTime;

        State(long delay, long currentTime) {
            this.delay = delay;
            this.runTime = currentTime + delay;
        }
    }
}

