/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.api.adapters;

import io.lumine.mythic.api.adapters.AbstractItemStack;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.adapters.AbstractPotionEffect;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.adapters.AbstractWorld;
import io.lumine.mythic.bukkit.utils.numbers.RangedDouble;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.entity.Entity;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;

public interface AbstractEntity {
    public AbstractLocation getLocation();

    public Entity getBukkitEntity();

    public boolean isLiving();

    public boolean isMob();

    public boolean isCreature();

    public boolean isPlayer();

    public boolean isAnimal();

    public boolean isWaterMob();

    public boolean isFlyingMob();

    public UUID getUniqueId();

    default public int getEntityId() {
        return this.getBukkitEntity().getEntityId();
    }

    public boolean hasLineOfSight(AbstractEntity var1);

    public void teleport(AbstractLocation var1);

    public void setRemoveWhenFarAway(boolean var1);

    public void setSaveToDisk(boolean var1);

    public double getHealth();

    public void setBlockInteractionRange(double var1);

    public void setEntityInteractionRange(double var1);

    public void setBlockBreakSpeed(double var1);

    public boolean isDead();

    public boolean isValid();

    public boolean remove();

    public double getMaxHealth();

    public void setMaxHealth(double var1);

    public void setHealth(double var1);

    public void setHealthAndMax(double var1);

    public double getDamage();

    public double getDamageBase();

    public void setDamage(double var1);

    public double getArmor();

    public double getArmorBase();

    public void setArmor(double var1);

    public double getArmorToughness();

    public double getArmorToughnessBase();

    public void setArmorToughness(double var1);

    public double getModelScaleBase();

    public double getModelScale();

    public void setModelScale(double var1);

    public void setStepHeight(double var1);

    public void setBurningTime(double var1);

    public void setExplosionKnockbackResistance(double var1);

    public void setFallDamageMultiplier(double var1);

    public void setGravityAttribute(double var1);

    public void setJumpStrength(double var1);

    public void setKnockbackResistance(double var1);

    public void setMovementEfficiency(double var1);

    public void setOxygenBonus(double var1);

    public void setSafeFallDistance(double var1);

    public void setSneakingSpeed(double var1);

    public void setWaterMovementEfficiency(double var1);

    public void setFireTicks(int var1);

    public Object getCustomName();

    public void setPassenger(Entity var1);

    public AbstractLocation getEyeLocation();

    public double getEyeHeight();

    public AbstractWorld getWorld();

    public double getHeight();

    public double getPassengerRidingOffset();

    public float getPassengerRidingOffset(AbstractEntity var1);

    public double getNameplateHeight();

    public double getNameplateMountOffset();

    public AbstractEntity getTarget();

    public AbstractEntity getVehicle();

    public boolean leaveVehicle();

    public void eject();

    public String getName();

    public Optional<String> getFaction();

    public boolean damage(float var1);

    public void setPassenger(AbstractEntity var1);

    public AbstractPlayer asPlayer();

    public void setNoDamageTicks(int var1);

    public int getNoDamageTicks();

    public boolean isMonster();

    public boolean isCitizensNPC();

    public boolean isGliding();

    public void addPotionEffect(AbstractPotionEffect var1);

    public void removePotionEffect(String var1);

    public void removePotionEffectType(AbstractPotionEffect var1);

    public boolean hasPotionEffect(String var1);

    public boolean hasPotionEffect(String var1, RangedDouble var2, RangedDouble var3);

    public boolean hasPotionEffect();

    public boolean hasScoreboardTag(String var1);

    public void addScoreboardTag(String var1);

    public void removeScoreboardTag(String var1);

    public AbstractEntity getPassenger();

    public void addPassenger(Entity var1);

    public Collection<AbstractEntity> getPassengers();

    public void removePassenger(Entity var1);

    public boolean hasGravity();

    public void setGravity(boolean var1);

    public Optional<AbstractItemStack> getItemHead();

    public void equipItemHead(AbstractItemStack var1);

    public Optional<AbstractItemStack> getItemChest();

    public void equipItemChest(AbstractItemStack var1);

    public Optional<AbstractItemStack> getItemLegs();

    public void equipItemLegs(AbstractItemStack var1);

    public Optional<AbstractItemStack> getItemFeet();

    public void equipItemFeet(AbstractItemStack var1);

    public Optional<AbstractItemStack> getItemMainHand();

    public void equipItemMainHand(AbstractItemStack var1);

    public Optional<AbstractItemStack> getItemOffhand();

    public void equipItemOffHand(AbstractItemStack var1);

    public void setMovementSpeed(double var1);

    public void setAttackSpeed(double var1);

    public int getLuck();

    public void setMetadata(String var1, Object var2);

    public boolean hasMetadata(String var1);

    public void removeMetadata(String var1);

    public Optional<Object> getMetadata(String var1);

    public boolean isLoaded();

    public boolean hasAI();

    public void setAI(boolean var1);

    public boolean isAware();

    public void setAware(boolean var1);

    public void setVelocity(AbstractVector var1);

    public int getEnchantmentLevel(String var1);

    public int getEnchantmentLevelHeld(String var1);

    public boolean isOnGround();

    public AbstractVector getVelocity();

    public boolean isDamageable();

    public void setFreezingTicks(int var1);

    public boolean isFreezing();

    public int getFreezingTicks();

    public int getMaxFreezingTicks();

    public PersistentDataContainer getDataContainer();

    public void setSavesToDisk(boolean var1);

    public boolean hasLineOfSight(AbstractLocation var1);

    public void setCustomName(String var1);

    public AbstractVector getMotion();

    public double getAbsorption();

    default public double distanceSquared(AbstractEntity other, DistanceMode mode) {
        return switch (mode.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> this.getLocation().distanceSquared(other.getLocation());
            case 1 -> other.getLocation().distanceSquared(this);
            case 2 -> this.getLocation().distanceSquared(other);
            case 3 -> {
                BoundingBox boxA = this.getBukkitEntity().getBoundingBox();
                Vector minA = boxA.getMin();
                Vector maxA = boxA.getMax();
                BoundingBox boxB = other.getBukkitEntity().getBoundingBox();
                Vector minB = boxB.getMin();
                Vector maxB = boxB.getMax();
                double ux = Math.max(0.0, minA.getX() - maxB.getX());
                double uy = Math.max(0.0, minA.getY() - maxB.getY());
                double uz = Math.max(0.0, minA.getZ() - maxB.getZ());
                double vx = Math.max(0.0, minB.getX() - maxA.getX());
                double vy = Math.max(0.0, minB.getY() - maxA.getY());
                double vz = Math.max(0.0, minB.getZ() - maxA.getZ());
                yield ux * ux + uy * uy + uz * uz + vx * vx + vy * vy + vz * vz;
            }
        };
    }

    public static enum DistanceMode {
        POS,
        SELF_BOX,
        OTHER_BOX,
        BOX;

    }
}

