/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.api.adapters.items.components;

import io.lumine.mythic.api.adapters.AbstractItemComponent;
import io.lumine.mythic.api.adapters.AbstractItemStack;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.drops.DropMetadata;
import io.lumine.mythic.core.items.MythicItem;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.EquipmentSlot;

public class AbstractItemEquippableComponent
implements AbstractItemComponent {
    private NamespacedKey model;
    private EquipmentSlot slot;
    private String equipSound;
    private NamespacedKey cameraOverlay;
    private List<String> entityTypes;
    private Boolean dispensable;
    private Boolean swappable;
    private Boolean damageOnHurt;

    public AbstractItemEquippableComponent(MythicItem item) {
        this.slot = this.getDefaultSlot(item.getMaterial());
    }

    public AbstractItemEquippableComponent(MythicItem item, MythicConfig config) {
        String equipSoundConfig;
        String slot;
        Object model = config.getString("Model");
        if (model != null) {
            if (!((String)model).contains(":")) {
                model = "minecraft:" + (String)model;
            }
            this.model = NamespacedKey.fromString((String)model);
        }
        this.slot = (slot = config.getString("Slot")) != null ? EquipmentSlot.valueOf((String)slot) : this.getDefaultSlot(item.getMaterial());
        Object cameraOverlay = config.getString("CameraOverlay");
        if (cameraOverlay != null) {
            if (!((String)cameraOverlay).contains(":")) {
                cameraOverlay = "minecraft:" + (String)cameraOverlay;
            }
            this.cameraOverlay = NamespacedKey.fromString((String)cameraOverlay);
        }
        if (config.isSet("Dispensable")) {
            this.dispensable = config.getBoolean("Dispensable");
        }
        if (config.isSet("Swappable")) {
            this.swappable = config.getBoolean("Swappable");
        }
        if (config.isSet("DamageOnHurt")) {
            this.damageOnHurt = config.getBoolean("DamageOnHurt");
        }
        if ((equipSoundConfig = config.getString("EquipSound")) != null) {
            this.equipSound = equipSoundConfig;
        }
        this.entityTypes = config.getStringList("EntityTypes", new ArrayList<String>());
    }

    @Override
    public void apply(MythicItem mythicItem, DropMetadata dropMetadata, AbstractItemStack itemStack) {
        itemStack.applyEquippableComponent(this);
    }

    private EquipmentSlot getDefaultSlot(Material material) {
        String mat = material.toString();
        if (mat.contains("_HELMET")) {
            return EquipmentSlot.HEAD;
        }
        if (mat.contains("_CHESTPLATE")) {
            return EquipmentSlot.CHEST;
        }
        if (mat.contains("_LEGGINGS")) {
            return EquipmentSlot.LEGS;
        }
        if (mat.contains("_BOOTS")) {
            return EquipmentSlot.FEET;
        }
        if (mat.equals("SHIELD")) {
            return EquipmentSlot.OFF_HAND;
        }
        return EquipmentSlot.HAND;
    }

    public NamespacedKey getModel() {
        return this.model;
    }

    public EquipmentSlot getSlot() {
        return this.slot;
    }

    public String getEquipSound() {
        return this.equipSound;
    }

    public NamespacedKey getCameraOverlay() {
        return this.cameraOverlay;
    }

    public List<String> getEntityTypes() {
        return this.entityTypes;
    }

    public Boolean getDispensable() {
        return this.dispensable;
    }

    public Boolean getSwappable() {
        return this.swappable;
    }

    public Boolean getDamageOnHurt() {
        return this.damageOnHurt;
    }

    public void setModel(NamespacedKey model) {
        this.model = model;
    }

    public void setSlot(EquipmentSlot slot) {
        this.slot = slot;
    }

    public void setEquipSound(String equipSound) {
        this.equipSound = equipSound;
    }

    public void setCameraOverlay(NamespacedKey cameraOverlay) {
        this.cameraOverlay = cameraOverlay;
    }

    public void setEntityTypes(List<String> entityTypes) {
        this.entityTypes = entityTypes;
    }

    public void setDispensable(Boolean dispensable) {
        this.dispensable = dispensable;
    }

    public void setSwappable(Boolean swappable) {
        this.swappable = swappable;
    }

    public void setDamageOnHurt(Boolean damageOnHurt) {
        this.damageOnHurt = damageOnHurt;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractItemEquippableComponent)) {
            return false;
        }
        AbstractItemEquippableComponent other = (AbstractItemEquippableComponent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$dispensable = this.getDispensable();
        Boolean other$dispensable = other.getDispensable();
        if (this$dispensable == null ? other$dispensable != null : !((Object)this$dispensable).equals(other$dispensable)) {
            return false;
        }
        Boolean this$swappable = this.getSwappable();
        Boolean other$swappable = other.getSwappable();
        if (this$swappable == null ? other$swappable != null : !((Object)this$swappable).equals(other$swappable)) {
            return false;
        }
        Boolean this$damageOnHurt = this.getDamageOnHurt();
        Boolean other$damageOnHurt = other.getDamageOnHurt();
        if (this$damageOnHurt == null ? other$damageOnHurt != null : !((Object)this$damageOnHurt).equals(other$damageOnHurt)) {
            return false;
        }
        NamespacedKey this$model = this.getModel();
        NamespacedKey other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        EquipmentSlot this$slot = this.getSlot();
        EquipmentSlot other$slot = other.getSlot();
        if (this$slot == null ? other$slot != null : !this$slot.equals(other$slot)) {
            return false;
        }
        String this$equipSound = this.getEquipSound();
        String other$equipSound = other.getEquipSound();
        if (this$equipSound == null ? other$equipSound != null : !this$equipSound.equals(other$equipSound)) {
            return false;
        }
        NamespacedKey this$cameraOverlay = this.getCameraOverlay();
        NamespacedKey other$cameraOverlay = other.getCameraOverlay();
        if (this$cameraOverlay == null ? other$cameraOverlay != null : !this$cameraOverlay.equals(other$cameraOverlay)) {
            return false;
        }
        List<String> this$entityTypes = this.getEntityTypes();
        List<String> other$entityTypes = other.getEntityTypes();
        return !(this$entityTypes == null ? other$entityTypes != null : !((Object)this$entityTypes).equals(other$entityTypes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractItemEquippableComponent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $dispensable = this.getDispensable();
        result = result * 59 + ($dispensable == null ? 43 : ((Object)$dispensable).hashCode());
        Boolean $swappable = this.getSwappable();
        result = result * 59 + ($swappable == null ? 43 : ((Object)$swappable).hashCode());
        Boolean $damageOnHurt = this.getDamageOnHurt();
        result = result * 59 + ($damageOnHurt == null ? 43 : ((Object)$damageOnHurt).hashCode());
        NamespacedKey $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        EquipmentSlot $slot = this.getSlot();
        result = result * 59 + ($slot == null ? 43 : $slot.hashCode());
        String $equipSound = this.getEquipSound();
        result = result * 59 + ($equipSound == null ? 43 : $equipSound.hashCode());
        NamespacedKey $cameraOverlay = this.getCameraOverlay();
        result = result * 59 + ($cameraOverlay == null ? 43 : $cameraOverlay.hashCode());
        List<String> $entityTypes = this.getEntityTypes();
        result = result * 59 + ($entityTypes == null ? 43 : ((Object)$entityTypes).hashCode());
        return result;
    }

    public String toString() {
        return "AbstractItemEquippableComponent(model=" + String.valueOf(this.getModel()) + ", slot=" + String.valueOf(this.getSlot()) + ", equipSound=" + this.getEquipSound() + ", cameraOverlay=" + String.valueOf(this.getCameraOverlay()) + ", entityTypes=" + String.valueOf(this.getEntityTypes()) + ", dispensable=" + this.getDispensable() + ", swappable=" + this.getSwappable() + ", damageOnHurt=" + this.getDamageOnHurt() + ")";
    }
}

