/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.api.mobs.entities;

import com.google.common.collect.Maps;
import io.lumine.mythic.api.mobs.entities.SpawnReason;
import io.lumine.mythic.bukkit.adapters.BukkitAttribute;
import io.lumine.mythic.bukkit.adapters.BukkitEntityType;
import io.lumine.mythic.bukkit.adapters.attributes.BukkitAttributable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Registry;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;

public enum MythicEntityType {
    ALLAY(new String[0]),
    ARMADILLO(new String[0]),
    ARMOR_STAND(new String[0]),
    AXOLOTL(new String[0]),
    BABY_DROWNED(new String[0]),
    BABY_HUSK(new String[0]),
    BABY_PIGLIN(new String[0]),
    BABY_PIGLIN_BRUTE(new String[0]),
    BABY_PIG_ZOMBIE(new String[0]),
    BABY_PIG_ZOMBIE_VILLAGER(new String[0]),
    BABY_ZOGLIN(new String[0]),
    BABY_ZOMBIE(new String[0]),
    BABY_ZOMBIE_VILLAGER("BABY_VILLAGER_ZOMBIE"),
    BAT(new String[0]),
    BEE(new String[0]),
    BLAZE(new String[0]),
    BLOCK_DISPLAY(new String[0]),
    BOGGED(new String[0]),
    BREEZE(new String[0]),
    BOAT(new String[0]),
    CAT(new String[0]),
    CAMEL(new String[0]),
    CAVE_SPIDER(new String[0]),
    CHEST_BOAT(new String[0]),
    CHICKEN(new String[0]),
    COD(new String[0]),
    COW(new String[0]),
    CREAKING(new String[0]),
    CREAKING_TRANSIENT(new String[0]),
    CREEPER(new String[0]),
    CUSTOM(new String[0]),
    DOLPHIN(new String[0]),
    DONKEY(new String[0]),
    DROWNED(new String[0]),
    ELDER_GUARDIAN(new String[0]),
    ENDER_DRAGON(new String[0]),
    ENDERMAN(new String[0]),
    ENDERMITE(new String[0]),
    EVOKER(new String[0]),
    EXPERIENCE_BOTTLE("THROWN_EXP_BOTTLE"),
    EXPERIENCE_ORB(new String[0]),
    FALLING_BLOCK(new String[0]),
    FOX(new String[0]),
    FROG(new String[0]),
    GHAST(new String[0]),
    GIANT(new String[0]),
    GOAT(new String[0]),
    GLOW_SQUID("GLOWING_SQUID"),
    GUARDIAN(new String[0]),
    HOGLIN(new String[0]),
    HORSE(new String[0]),
    HUSK(new String[0]),
    ILLUSIONER(new String[0]),
    INTERACTION(new String[0]),
    IRON_GOLEM("VILLAGER_GOLEM"),
    ITEM("DROPPED_ITEM"),
    ITEM_DISPLAY(new String[0]),
    LLAMA(new String[0]),
    MAGMA_CUBE("LAVA_SLIME"),
    MARKER(new String[0]),
    MINECART(new String[0]),
    MINECART_CHEST("CHEST_MINECART"),
    MINECART_COMMAND("COMMAND_BLOCK_MINECART", "COMMAND_MINECART"),
    MINECART_FURNACE("FURNACE_MINECART"),
    MINECART_HOPPER("HOPPER_MINECART"),
    MINECART_MOB_SPAWNER("SPAWNER_MINECART"),
    MINECART_TNT("TNT_MINECART"),
    MULE(new String[0]),
    MUSHROOM_COW("MOOSHROOM", "COW_MUSHROOM"),
    OCELOT(new String[0]),
    PANDA(new String[0]),
    PARROT(new String[0]),
    PHANTOM(new String[0]),
    PIG(new String[0]),
    PIGLIN("PIGMAN"),
    PIGLIN_BRUTE(new String[0]),
    ZOMBIFIED_PIGLIN("ZOMBIE_PIGMAN", "PIG_ZOMBIE", "ZOMBIE_PIG"),
    ZOMBIFIED_PIGLIN_VILLAGER(new String[0]),
    PILLAGER(new String[0]),
    POLAR_BEAR(new String[0]),
    PRIMED_TNT("TNT"),
    PUFFERFISH(new String[0]),
    RABBIT(new String[0]),
    RAVAGER(new String[0]),
    SALMON(new String[0]),
    SHEEP(new String[0]),
    SHULKER(new String[0]),
    SILVERFISH(new String[0]),
    SKELETON(new String[0]),
    SKELETON_HORSE("SKELETAL_HORSE"),
    SLIME(new String[0]),
    SNIFFER(new String[0]),
    SNOWMAN("SNOW_GOLEM"),
    SPIDER(new String[0]),
    STRAY(new String[0]),
    STRIDER(new String[0]),
    SQUID(new String[0]),
    TADPOLE(new String[0]),
    TEXT_DISPLAY(new String[0]),
    TRADER_LLAMA(new String[0]),
    TROPICAL_FISH(new String[0]),
    TURTLE(new String[0]),
    VEX(new String[0]),
    VILLAGER(new String[0]),
    VINDICATOR("VINDIOCELOTOR"),
    WANDERING_TRADER(new String[0]),
    WARDEN(new String[0]),
    WITCH(new String[0]),
    WITHER(new String[0]),
    WITHER_SKELETON(new String[0]),
    WOLF(new String[0]),
    ZOGLIN(new String[0]),
    ZOMBIE(new String[0]),
    ZOMBIE_HORSE("ZOMBIFIED_HORSE"),
    ZOMBIE_VILLAGER("VILLAGER_ZOMBIE");

    private static final Map<String, MythicEntityType> ALIASES;
    private final String[] aliases;
    private final Map<String, Double> defaultAttributes = Maps.newConcurrentMap();
    private double defaultHeight = 2.0;
    private boolean defaultValuesInitialized = false;

    private MythicEntityType(String ... aliases) {
        this.aliases = aliases;
    }

    public void initializeDefaultValues(BukkitAttributable attributable) {
        BukkitAttribute.values().forEach(attribute -> {
            if (attributable.getAttribute(attribute.toString()) != null) {
                double value = attributable.getAttribute(attribute.toString()).getBaseValue();
                this.defaultAttributes.put(attribute.getAttributeKey().toString(), value);
            }
        });
        this.defaultValuesInitialized = true;
    }

    public void initializeDefaultValues() {
        Location location = new Location((World)Bukkit.getWorlds().get(0), 0.0, 1000.0, 0.0);
        Entity entity = BukkitEntityType.getMythicEntity(this).spawn(location, SpawnReason.OTHER, spawnedEntity -> {
            this.defaultHeight = spawnedEntity.getHeight();
            if (spawnedEntity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)spawnedEntity;
                Registry.ATTRIBUTE.forEach(attribute -> {
                    if (livingEntity.getAttribute(attribute) != null) {
                        double value = livingEntity.getAttribute(attribute).getBaseValue();
                        this.defaultAttributes.put(attribute.getKey().toString(), value);
                    }
                });
            }
        });
        entity.remove();
        this.defaultValuesInitialized = true;
    }

    public Optional<Double> getAttributeDefault(Attribute attribute) {
        return Optional.ofNullable(this.defaultAttributes.getOrDefault(attribute.getKey().toString(), null));
    }

    public static MythicEntityType get(String entityType) {
        if (entityType == null) {
            return null;
        }
        MythicEntityType type = ALIASES.get(entityType = entityType.toUpperCase());
        if (type == null) {
            try {
                EntityType.valueOf((String)entityType);
                return CUSTOM;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return type;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    static {
        ALIASES = new HashMap<String, MythicEntityType>();
        for (MythicEntityType met : MythicEntityType.values()) {
            ALIASES.put(met.toString().toUpperCase(), met);
            ALIASES.put(met.toString().toUpperCase().replace("_", ""), met);
            for (String alias : met.getAliases()) {
                ALIASES.put(alias.toUpperCase(), met);
                ALIASES.put(alias.toString().toUpperCase().replace("_", ""), met);
            }
        }
    }
}

