/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.api.volatilecode.handlers;

import com.google.common.collect.Lists;
import io.lumine.mythic.api.adapters.AbstractBiome;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.adapters.AbstractStructure;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.adapters.AbstractWorld;
import io.lumine.mythic.api.volatilecode.virtual.PacketArmorStand;
import io.lumine.mythic.api.volatilecode.virtual.PacketBlockDisplay;
import io.lumine.mythic.api.volatilecode.virtual.PacketFallingBlock;
import io.lumine.mythic.api.volatilecode.virtual.PacketItem;
import io.lumine.mythic.api.volatilecode.virtual.PacketItemDisplay;
import io.lumine.mythic.api.volatilecode.virtual.PacketTextDisplay;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.core.volatilecode.disabled.VolatileBiomeDisabled;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Predicate;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.entity.Entity;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public interface VolatileWorldHandler {
    default public AbstractBiome getBiome(AbstractLocation target) {
        return new VolatileBiomeDisabled(BukkitAdapter.adapt(target).getBlock().getBiome());
    }

    default public Optional<AbstractBiome> getBiome(String key) {
        try {
            Biome biome = Biome.valueOf((String)key.toUpperCase());
            return Optional.of(new VolatileBiomeDisabled(biome));
        }
        catch (Error | Exception ex) {
            return Optional.empty();
        }
    }

    default public Collection<AbstractBiome> getBiomes() {
        ArrayList biomes = Lists.newArrayList();
        for (Biome biome : Biome.values()) {
            biomes.add(new VolatileBiomeDisabled(biome));
        }
        return biomes;
    }

    default public Optional<AbstractStructure> getStructure(String key) {
        return Optional.empty();
    }

    default public Collection<AbstractStructure> getStructures() {
        return Lists.newArrayList();
    }

    default public Collection<AbstractStructure> getStructures(AbstractLocation target) {
        return Lists.newArrayList();
    }

    public void playSoundAtLocation(AbstractLocation var1, String var2, float var3, float var4, double var5);

    default public boolean isChunkLoaded(AbstractWorld world, int x, int z) {
        return true;
    }

    public Collection<AbstractEntity> getEntities(AbstractWorld var1);

    public Collection<AbstractEntity> getLivingEntities(AbstractWorld var1);

    public Collection<AbstractPlayer> getPlayers(AbstractWorld var1);

    default public int getEntitiesInChunk(AbstractWorld world, int x, int z) {
        return 0;
    }

    public float getDifficultyScale(AbstractLocation var1);

    default public Collection<AbstractEntity> getEntitiesNearLocation(AbstractLocation location, double radius) {
        return this.getEntitiesNearLocation(location, radius, null);
    }

    default public Collection<AbstractEntity> getEntitiesNearLocation(AbstractLocation location, double radius, Predicate<AbstractEntity> predicate) {
        return new ObjectArrayList();
    }

    default public RayTraceResult rayTraceBlock(AbstractLocation start, AbstractVector direction, double maxDistance, FluidCollisionMode fluidCollisionMode, boolean ignorePassableBlocks) {
        if (maxDistance < 0.0 || start.getWorld() == null) {
            return null;
        }
        AbstractVector dir = direction.clone().normalize().multiply(maxDistance);
        AbstractLocation end = start.clone().add(dir);
        return this.rayTraceBlock(start, end, fluidCollisionMode, ignorePassableBlocks);
    }

    default public RayTraceResult rayTraceBlock(AbstractLocation start, AbstractLocation end, FluidCollisionMode fluidCollisionMode, boolean ignorePassableBlocks) {
        return null;
    }

    default public RayTraceResult rayTrace(AbstractLocation start, AbstractVector direction, double maxDistance, FluidCollisionMode fluidCollisionMode, double raySize, Predicate<Entity> entityFilter, Predicate<Material> blockFilter) {
        return this.rayTrace(BukkitAdapter.adapt(start), BukkitAdapter.adapt(direction), maxDistance, fluidCollisionMode, raySize, entityFilter, blockFilter);
    }

    default public RayTraceResult rayTrace(Location start, Vector direction, double maxDistance, FluidCollisionMode fluidCollisionMode, double raySize, Predicate<Entity> entityFilter, Predicate<Material> blockFilter) {
        return null;
    }

    default public RayTraceResult rayTrace(Location start, Vector direction, double maxDistance, double raySize, Predicate<Entity> entityFilter, Predicate<Material> blockFilter) {
        return this.rayTrace(start, direction, maxDistance, FluidCollisionMode.NEVER, raySize, entityFilter, blockFilter);
    }

    default public RayTraceResult rayTrace(Location start, Location end, FluidCollisionMode fluidCollisionMode, double raySize, Predicate<Entity> entityFilter, Predicate<Material> blockFilter) {
        Vector direction = end.subtract(start).toVector().normalize();
        double maxDistance = start.distance(end);
        return this.rayTrace(start, direction, maxDistance, fluidCollisionMode, raySize, entityFilter, blockFilter);
    }

    public Entity spawnInvisibleArmorStand(Location var1);

    public PacketArmorStand.PacketArmorStandEntityRenderer createVirtualArmorStandRenderer(PacketArmorStand var1);

    public PacketFallingBlock.PacketFallingBlockEntityRenderer createVirtualBlockRenderer(PacketFallingBlock var1);

    default public PacketBlockDisplay.PacketBlockDisplayEntityRenderer createVirtualDisplayBlockEntityRenderer(PacketBlockDisplay wrapper) {
        throw new IllegalStateException("DisplayEntities are only available on 1.19.4+");
    }

    default public PacketItemDisplay.PacketItemDisplayEntityRenderer createVirtualDisplayItemEntityRenderer(PacketItemDisplay wrapper) {
        throw new IllegalStateException("DisplayEntities are only available on 1.19.4+");
    }

    default public PacketTextDisplay.PacketTextDisplayEntityRenderer createVirtualTextDisplayEntityRenderer(PacketTextDisplay wrapper) {
        throw new IllegalStateException("TextDisplayEntities are only available on 1.19.4+");
    }

    public PacketItem.PacketItemEntityRenderer createVirtualItemRenderer(PacketItem var1);
}

