/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.adapters;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractItemStack;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.adapters.AbstractPotionEffect;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.adapters.AbstractWorld;
import io.lumine.mythic.api.volatilecode.VolatileCodeDisabled;
import io.lumine.mythic.api.volatilecode.VolatileCodeHandler;
import io.lumine.mythic.api.volatilecode.VolatileEnchantment;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.adapters.BukkitAttribute;
import io.lumine.mythic.bukkit.adapters.BukkitPlayer;
import io.lumine.mythic.bukkit.adapters.BukkitPotionEffect;
import io.lumine.mythic.bukkit.compatibility.AbstractModelEngineSupport;
import io.lumine.mythic.bukkit.compatibility.CitizensSupport;
import io.lumine.mythic.bukkit.compatibility.CompatibilityManager;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.numbers.RangedDouble;
import io.lumine.mythic.bukkit.utils.version.ServerVersion;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.utils.adventure.PaperHelper;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Flying;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.entity.WaterMob;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class BukkitEntity
implements AbstractEntity {
    private final Entity entityRef;

    public BukkitEntity(Entity e) {
        this.entityRef = e;
    }

    @Override
    public void setCustomName(String name) {
        VolatileCodeHandler handler = MythicBukkit.inst().getVolatileCodeHandler();
        if (handler instanceof VolatileCodeDisabled) {
            VolatileCodeDisabled disabled = (VolatileCodeDisabled)handler;
            if (ServerVersion.isPaper()) {
                this.getBukkitEntity().customName(PaperHelper.parse(name));
            } else {
                this.getBukkitEntity().setCustomName(name);
            }
        } else {
            handler.getEntityHandler().setCustomName(this, name);
        }
    }

    @Override
    public Entity getBukkitEntity() {
        return this.entityRef;
    }

    private LivingEntity getEntityAsLiving() {
        return (LivingEntity)this.getBukkitEntity();
    }

    private Mob getEntityAsMob() {
        return (Mob)this.getBukkitEntity();
    }

    private Creature getEntityAsCreature() {
        return (Creature)this.getBukkitEntity();
    }

    public Player getEntityAsPlayer() {
        return (Player)this.getBukkitEntity();
    }

    @Override
    public PersistentDataContainer getDataContainer() {
        return this.getBukkitEntity().getPersistentDataContainer();
    }

    @Override
    public AbstractLocation getLocation() {
        return BukkitAdapter.adapt(this.getBukkitEntity().getLocation());
    }

    @Override
    public AbstractWorld getWorld() {
        return this.getLocation().getWorld();
    }

    @Override
    public boolean isLiving() {
        return this.getBukkitEntity() instanceof LivingEntity;
    }

    @Override
    public boolean isMob() {
        return this.getBukkitEntity() instanceof Mob;
    }

    @Override
    public boolean isCreature() {
        return this.getBukkitEntity() instanceof Creature;
    }

    @Override
    public boolean isMonster() {
        return this.getBukkitEntity() instanceof Monster;
    }

    @Override
    public boolean isDamageable() {
        return this.getBukkitEntity() instanceof Damageable;
    }

    @Override
    public boolean isPlayer() {
        return this.getBukkitEntity() instanceof Player;
    }

    @Override
    public UUID getUniqueId() {
        return this.getBukkitEntity().getUniqueId();
    }

    @Override
    public boolean hasLineOfSight(AbstractEntity e) {
        return ((LivingEntity)this.getBukkitEntity()).hasLineOfSight(e.getBukkitEntity());
    }

    @Override
    public boolean hasLineOfSight(AbstractLocation location) {
        return !((LivingEntity)this.getBukkitEntity()).hasLineOfSight(BukkitAdapter.adapt(location));
    }

    @Override
    public void teleport(AbstractLocation l) {
        if (this.getBukkitEntity().isValid() && !this.getBukkitEntity().isDead() && l.isFinite()) {
            this.getBukkitEntity().teleport(BukkitAdapter.adapt(l));
        }
    }

    @Override
    public void setRemoveWhenFarAway(boolean bool) {
        Entity entity = this.getBukkitEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            living.setRemoveWhenFarAway(bool);
        }
    }

    @Override
    public void setSaveToDisk(boolean bool) {
        this.getBukkitEntity().setPersistent(bool);
    }

    @Override
    public double getHealth() {
        if (this.isLiving()) {
            return this.getEntityAsLiving().getHealth();
        }
        return 0.0;
    }

    @Override
    public double getAbsorption() {
        if (this.isLiving()) {
            return this.getEntityAsLiving().getAbsorptionAmount();
        }
        return 0.0;
    }

    @Override
    public double getMaxHealth() {
        if (this.isLiving()) {
            return this.getEntityAsLiving().getAttribute(BukkitAttribute.getAttribute("MAX_HEALTH")).getValue();
        }
        return 0.0;
    }

    @Override
    public void setMaxHealth(double health) {
        if (!this.isLiving()) {
            return;
        }
        try {
            this.getEntityAsLiving().getAttribute(BukkitAttribute.getAttribute("MAX_HEALTH")).setBaseValue(health);
        }
        catch (IllegalArgumentException ex) {
            MythicLogger.error("Tried to set MAX_HEALTH for {0} greater than server's maxHealth setting. Please modify spigot.yml and increase the maxHealth attribute to compensate.", this.getUniqueId());
            MythicLogger.handleMinorError(ex);
        }
    }

    @Override
    public void setHealth(double value) {
        if (this.isLiving()) {
            LivingEntity le = this.getEntityAsLiving();
            if (value < 0.0) {
                le.setHealth(0.0);
            } else if (value > this.getMaxHealth()) {
                le.setHealth(this.getMaxHealth());
            } else {
                le.setHealth(value);
            }
        }
    }

    @Override
    public void setHealthAndMax(double value) {
        this.setMaxHealth(value);
        this.setHealth(value);
    }

    @Override
    public double getDamage() {
        if (this.isLiving()) {
            if (this.getEntityAsLiving().getAttribute(BukkitAttribute.getAttribute("ATTACK_DAMAGE")) == null) {
                return 0.0;
            }
            return this.getEntityAsLiving().getAttribute(BukkitAttribute.getAttribute("ATTACK_DAMAGE")).getValue();
        }
        return 0.0;
    }

    @Override
    public double getDamageBase() {
        if (this.isLiving()) {
            if (this.getEntityAsLiving().getAttribute(BukkitAttribute.getAttribute("ATTACK_DAMAGE")) == null) {
                return 0.0;
            }
            return this.getEntityAsLiving().getAttribute(BukkitAttribute.getAttribute("ATTACK_DAMAGE")).getBaseValue();
        }
        return 0.0;
    }

    @Override
    public void setDamage(double value) {
        if (!this.isLiving()) {
            return;
        }
        if (this.getEntityAsLiving().getAttribute(BukkitAttribute.getAttribute("ATTACK_DAMAGE")) == null) {
            try {
                MythicBukkit.inst().getVolatileCodeHandler().getEntityHandler().registerAttribute(this, BukkitAttribute.getAttribute("ATTACK_DAMAGE"));
            }
            catch (Exception e) {
                MythicLogger.debug(MythicLogger.DebugLevel.INFO, "Failed to register {0} attribute to entity", BukkitAttribute.getAttribute("ATTACK_DAMAGE"));
                return;
            }
        }
        this.getEntityAsLiving().getAttribute(BukkitAttribute.getAttribute("ATTACK_DAMAGE")).setBaseValue(value);
        if (CompatibilityManager.Heroes != null) {
            CompatibilityManager.Heroes.setMobDamage(this.getEntityAsLiving(), value);
        }
    }

    @Override
    public double getArmor() {
        if (this.isLiving()) {
            if (this.getEntityAsLiving().getAttribute(BukkitAttribute.getAttribute("ARMOR")) == null) {
                return 0.0;
            }
            return this.getEntityAsLiving().getAttribute(BukkitAttribute.getAttribute("ARMOR")).getValue();
        }
        return 0.0;
    }

    @Override
    public double getArmorBase() {
        if (this.isLiving()) {
            if (this.getEntityAsLiving().getAttribute(BukkitAttribute.getAttribute("ARMOR")) == null) {
                return 0.0;
            }
            return this.getEntityAsLiving().getAttribute(BukkitAttribute.getAttribute("ARMOR")).getBaseValue();
        }
        return 0.0;
    }

    @Override
    public void setArmor(double value) {
        if (!this.isLiving()) {
            return;
        }
        if (this.getEntityAsLiving().getAttribute(BukkitAttribute.getAttribute("ARMOR")) == null) {
            try {
                MythicBukkit.inst().getVolatileCodeHandler().getEntityHandler().registerAttribute(this, BukkitAttribute.getAttribute("ARMOR"));
            }
            catch (Exception e) {
                MythicLogger.debug(MythicLogger.DebugLevel.INFO, "Failed to register {0} attribute to entity", BukkitAttribute.getAttribute("ARMOR"));
                return;
            }
        }
        this.getEntityAsLiving().getAttribute(BukkitAttribute.getAttribute("ARMOR")).setBaseValue(value);
    }

    @Override
    public double getArmorToughness() {
        if (this.isLiving()) {
            if (this.getEntityAsLiving().getAttribute(BukkitAttribute.getAttribute("ARMOR_TOUGHNESS")) == null) {
                return 0.0;
            }
            return this.getEntityAsLiving().getAttribute(BukkitAttribute.getAttribute("ARMOR_TOUGHNESS")).getValue();
        }
        return 0.0;
    }

    @Override
    public double getArmorToughnessBase() {
        if (this.isLiving()) {
            if (this.getEntityAsLiving().getAttribute(BukkitAttribute.getAttribute("ARMOR_TOUGHNESS")) == null) {
                return 0.0;
            }
            return this.getEntityAsLiving().getAttribute(BukkitAttribute.getAttribute("ARMOR_TOUGHNESS")).getBaseValue();
        }
        return 0.0;
    }

    @Override
    public void setArmorToughness(double value) {
        if (!this.isLiving()) {
            return;
        }
        if (this.getEntityAsLiving().getAttribute(BukkitAttribute.getAttribute("ARMOR_TOUGHNESS")) == null) {
            try {
                MythicBukkit.inst().getVolatileCodeHandler().getEntityHandler().registerAttribute(this, BukkitAttribute.getAttribute("ARMOR_TOUGHNESS"));
            }
            catch (Exception e) {
                MythicLogger.debug(MythicLogger.DebugLevel.INFO, "Failed to register {0} attribute to entity", BukkitAttribute.getAttribute("ARMOR_TOUGHNESS"));
                return;
            }
        }
        this.getEntityAsLiving().getAttribute(BukkitAttribute.getAttribute("ARMOR_TOUGHNESS")).setBaseValue(value);
    }

    @Override
    public double getModelScaleBase() {
        if (this.isLiving()) {
            if (this.getEntityAsLiving().getAttribute(BukkitAttribute.getAttribute("SCALE")) == null) {
                return 1.0;
            }
            return this.getEntityAsLiving().getAttribute(BukkitAttribute.getAttribute("SCALE")).getBaseValue();
        }
        return 1.0;
    }

    @Override
    public double getModelScale() {
        if (this.isLiving()) {
            if (this.getEntityAsLiving().getAttribute(BukkitAttribute.getAttribute("SCALE")) == null) {
                return 1.0;
            }
            return this.getEntityAsLiving().getAttribute(BukkitAttribute.getAttribute("SCALE")).getValue();
        }
        return 1.0;
    }

    @Override
    public void setModelScale(double newValue) {
        this.setAttributeBaseValue(BukkitAttribute.SCALE, newValue);
    }

    @Override
    public void setStepHeight(double newValue) {
        this.setAttributeBaseValue(BukkitAttribute.STEP_HEIGHT, newValue);
    }

    @Override
    public void setBurningTime(double newValue) {
        this.setAttributeBaseValue(BukkitAttribute.BURNING_TIME, newValue);
    }

    @Override
    public void setExplosionKnockbackResistance(double newValue) {
        this.setAttributeBaseValue(BukkitAttribute.EXPLOSION_KNOCKBACK_RESISTANCE, newValue);
    }

    @Override
    public void setFallDamageMultiplier(double newValue) {
        this.setAttributeBaseValue(BukkitAttribute.FALL_DAMAGE_MULTIPLIER, newValue);
    }

    @Override
    public void setGravityAttribute(double newValue) {
        this.setAttributeBaseValue(BukkitAttribute.GRAVITY, newValue);
    }

    @Override
    public void setJumpStrength(double newValue) {
        this.setAttributeBaseValue(BukkitAttribute.JUMP_HEIGHT, newValue);
    }

    @Override
    public void setKnockbackResistance(double newValue) {
        this.setAttributeBaseValue(BukkitAttribute.KNOCKBACK_RESISTANCE, newValue);
    }

    @Override
    public void setMovementEfficiency(double newValue) {
        this.setAttributeBaseValue(BukkitAttribute.MOVEMENT_EFFICIENCY, newValue);
    }

    @Override
    public void setOxygenBonus(double newValue) {
        this.setAttributeBaseValue(BukkitAttribute.OXYGEN, newValue);
    }

    @Override
    public void setSafeFallDistance(double newValue) {
        this.setAttributeBaseValue(BukkitAttribute.SAFE_FALL_DISTANCE, newValue);
    }

    @Override
    public void setSneakingSpeed(double newValue) {
        this.setAttributeBaseValue(BukkitAttribute.SNEAKING_SPEED, newValue);
    }

    @Override
    public void setWaterMovementEfficiency(double newValue) {
        this.setAttributeBaseValue(BukkitAttribute.WATER_MOVEMENT_EFFICIENCY, newValue);
    }

    @Override
    public void setBlockInteractionRange(double newValue) {
        this.setAttributeBaseValue(BukkitAttribute.BLOCK_INTERACTION_RANGE, newValue);
    }

    @Override
    public void setEntityInteractionRange(double newValue) {
        this.setAttributeBaseValue(BukkitAttribute.ENTITY_INTERACTION_RANGE, newValue);
    }

    @Override
    public void setBlockBreakSpeed(double newValue) {
        this.setAttributeBaseValue(BukkitAttribute.BLOCK_BREAK_SPEED, newValue);
    }

    private void setAttributeBaseValue(BukkitAttribute attribute, double newValue) {
        if (!this.isLiving()) {
            return;
        }
        if (this.getEntityAsLiving().getAttribute(attribute.getBukkitAttribute()) == null) {
            try {
                MythicBukkit.inst().getVolatileCodeHandler().getEntityHandler().registerAttribute(this, attribute.getBukkitAttribute());
            }
            catch (Exception e) {
                MythicLogger.debug(MythicLogger.DebugLevel.INFO, "Failed to register {0} attribute to entity", attribute.getAttributeKey().toString());
                return;
            }
        }
        this.getEntityAsLiving().getAttribute(attribute.getBukkitAttribute()).setBaseValue(newValue);
    }

    @Override
    public boolean isDead() {
        return this.getBukkitEntity().isDead();
    }

    @Override
    public boolean isValid() {
        return this.getBukkitEntity().isValid();
    }

    @Override
    public boolean remove() {
        Entity entity = this.entityRef;
        if (entity != null && !this.isPlayer()) {
            if (Bukkit.isPrimaryThread()) {
                entity.remove();
                return entity.isDead();
            }
            Schedulers.sync().run(() -> entity.remove());
            return true;
        }
        return true;
    }

    @Override
    public void setFireTicks(int ticks) {
        this.getBukkitEntity().setFireTicks(ticks);
    }

    @Override
    public String getCustomName() {
        return this.getEntityAsLiving().getCustomName();
    }

    @Override
    @Deprecated
    public void setPassenger(Entity entity) {
        this.getBukkitEntity().setPassenger(entity);
    }

    @Override
    public void addPassenger(Entity entity) {
        this.getBukkitEntity().addPassenger(entity);
    }

    @Override
    public Collection<AbstractEntity> getPassengers() {
        return this.getBukkitEntity().getPassengers().stream().map(entity -> BukkitAdapter.adapt(entity)).toList();
    }

    @Override
    public void removePassenger(Entity entity) {
        this.getBukkitEntity().removePassenger(entity);
    }

    @Override
    public boolean hasGravity() {
        return this.getBukkitEntity().hasGravity();
    }

    @Override
    public void setGravity(boolean bool) {
        this.getBukkitEntity().setGravity(bool);
    }

    @Override
    public boolean hasAI() {
        if (this.isLiving()) {
            return this.getEntityAsLiving().hasAI();
        }
        return false;
    }

    @Override
    public void setAI(boolean bool) {
        if (this.isLiving()) {
            this.getEntityAsLiving().setAI(bool);
        }
    }

    @Override
    public boolean isAware() {
        if (this.isMob()) {
            return this.getEntityAsMob().isAware();
        }
        return false;
    }

    @Override
    public void setAware(boolean bool) {
        if (this.isMob()) {
            this.getEntityAsMob().setAware(bool);
        }
    }

    @Override
    public AbstractLocation getEyeLocation() {
        if (this.isLiving()) {
            return BukkitAdapter.adapt(this.getEntityAsLiving().getEyeLocation());
        }
        return BukkitAdapter.adapt(this.getBukkitEntity().getLocation());
    }

    @Override
    public double getEyeHeight() {
        if (this.isLiving()) {
            return this.getEntityAsLiving().getEyeHeight();
        }
        return 0.0;
    }

    @Override
    public double getHeight() {
        return this.getBukkitEntity().getHeight();
    }

    @Override
    @Deprecated
    public double getPassengerRidingOffset() {
        return MythicBukkit.inst().getVolatileCodeHandler().getEntityHandler().getPassengerRidingOffset(this);
    }

    @Override
    public float getPassengerRidingOffset(AbstractEntity passenger) {
        return MythicBukkit.inst().getVolatileCodeHandler().getEntityHandler().getPassengerRidingOffset(this, passenger);
    }

    @Override
    public double getNameplateHeight() {
        return this.getHeight() + 0.25;
    }

    @Override
    public double getNameplateMountOffset() {
        return this.getNameplateHeight() + this.getPassengerRidingOffset();
    }

    @Override
    public AbstractEntity getTarget() {
        if (this.isCreature()) {
            return BukkitAdapter.adapt((Entity)this.getEntityAsCreature().getTarget());
        }
        if (this.getBukkitEntity().getLastDamageCause() != null) {
            return BukkitAdapter.adapt(this.getBukkitEntity().getLastDamageCause().getEntity());
        }
        return null;
    }

    @Override
    public AbstractEntity getPassenger() {
        Entity e = this.getBukkitEntity().getPassenger();
        if (e != null) {
            return BukkitAdapter.adapt(e);
        }
        return null;
    }

    @Override
    public AbstractEntity getVehicle() {
        Entity e = this.getBukkitEntity().getVehicle();
        if (e != null) {
            return BukkitAdapter.adapt(e);
        }
        return null;
    }

    @Override
    public boolean leaveVehicle() {
        return this.getBukkitEntity().leaveVehicle();
    }

    @Override
    public void eject() {
        this.getBukkitEntity().eject();
    }

    @Override
    public String getName() {
        if (this.isPlayer()) {
            return this.getEntityAsPlayer().getName();
        }
        if (this.getBukkitEntity().getCustomName() != null) {
            return this.getBukkitEntity().getCustomName();
        }
        if (this.getBukkitEntity().getName() != null) {
            return this.getBukkitEntity().getName();
        }
        return this.getBukkitEntity().getType().getName();
    }

    @Override
    public Optional<String> getFaction() {
        if (this.isPlayer()) {
            return MythicBukkit.inst().getPlayerManager().getFactionProvider().getFaction(this.asPlayer());
        }
        ActiveMob am = MythicBukkit.inst().getMobManager().getMythicMobInstance(this);
        if (am == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(am.getFaction());
    }

    @Override
    public boolean damage(float damage) {
        this.getEntityAsLiving().damage((double)damage);
        return true;
    }

    @Override
    public void setPassenger(AbstractEntity entity) {
        this.getBukkitEntity().setPassenger(BukkitAdapter.adapt(entity));
    }

    @Override
    public AbstractPlayer asPlayer() {
        if (this.getBukkitEntity() instanceof Player) {
            return new BukkitPlayer(this.getEntityAsPlayer());
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o instanceof BukkitEntity) {
            return this.getUniqueId().equals(((BukkitEntity)o).getUniqueId());
        }
        return super.equals(o);
    }

    public int hashCode() {
        return this.getBukkitEntity().getUniqueId().hashCode();
    }

    @Override
    public void setNoDamageTicks(int ticks) {
        if (this.isLiving()) {
            ((LivingEntity)this.getBukkitEntity()).setNoDamageTicks(ticks);
        }
    }

    @Override
    public int getNoDamageTicks() {
        if (this.isLiving()) {
            return ((LivingEntity)this.getBukkitEntity()).getNoDamageTicks();
        }
        return 0;
    }

    @Override
    public boolean isCitizensNPC() {
        Optional<CitizensSupport> citizens = MythicBukkit.inst().getCompatibility().getCitizens();
        if (citizens.isEmpty()) {
            return false;
        }
        return citizens.get().isCitizensNPC(this);
    }

    @Override
    public boolean isAnimal() {
        return this.getBukkitEntity() instanceof Animals;
    }

    @Override
    public boolean isWaterMob() {
        return this.getBukkitEntity() instanceof WaterMob;
    }

    @Override
    public boolean isFlyingMob() {
        return this.getBukkitEntity() instanceof Flying;
    }

    @Override
    public boolean isGliding() {
        return ((LivingEntity)this.getBukkitEntity()).isGliding();
    }

    @Override
    public void addPotionEffect(AbstractPotionEffect effect) {
        PotionEffect bukkitEffect = ((BukkitPotionEffect)effect).toBukkitEffect();
        this.getEntityAsLiving().addPotionEffect(bukkitEffect);
    }

    @Override
    public void removePotionEffect(String type) {
        PotionEffectType bukkitEffectType = BukkitPotionEffect.getEffectType(type);
        this.getEntityAsLiving().removePotionEffect(bukkitEffectType);
    }

    @Override
    public void removePotionEffectType(AbstractPotionEffect effect) {
        PotionEffectType bukkitEffectType = ((BukkitPotionEffect)effect).getEffect().getType();
        this.getEntityAsLiving().removePotionEffect(bukkitEffectType);
    }

    @Override
    public boolean hasPotionEffect(String type) {
        return this.hasPotionEffect(type, null, null);
    }

    @Override
    public boolean hasPotionEffect(String type, RangedDouble level, RangedDouble duration) {
        if (this.isLiving()) {
            PotionEffectType potiontype;
            LivingEntity e = (LivingEntity)this.getBukkitEntity();
            if (!e.hasPotionEffect(potiontype = PotionEffectType.getByName((String)type))) {
                MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "HasPotionEffect failed has check", new Object[0]);
                return false;
            }
            PotionEffect effect = e.getPotionEffect(potiontype);
            if (duration != null && !duration.equals(effect.getDuration())) {
                MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "HasPotionEffect failed duration check", new Object[0]);
                return false;
            }
            if (level != null && !level.equals(effect.getAmplifier())) {
                MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "HasPotionEffect failed level check", new Object[0]);
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean hasPotionEffect() {
        if (this.isLiving()) {
            LivingEntity e = (LivingEntity)this.getBukkitEntity();
            return e.getActivePotionEffects().size() > 0;
        }
        return false;
    }

    @Override
    public boolean hasScoreboardTag(String tag) {
        return this.getBukkitEntity().getScoreboardTags().contains(tag);
    }

    @Override
    public void addScoreboardTag(String tag) {
        this.getBukkitEntity().addScoreboardTag(tag);
    }

    @Override
    public void removeScoreboardTag(String tag) {
        this.getBukkitEntity().removeScoreboardTag(tag);
    }

    @Override
    public Optional<AbstractItemStack> getItemHead() {
        if (!this.isLiving()) {
            return Optional.empty();
        }
        EntityEquipment equipment = this.getEntityAsLiving().getEquipment();
        if (equipment == null) {
            return Optional.empty();
        }
        ItemStack item = equipment.getItem(EquipmentSlot.HEAD);
        return Optional.of(BukkitAdapter.adapt(item));
    }

    @Override
    public void equipItemHead(AbstractItemStack item) {
        if (!this.isLiving()) {
            return;
        }
        LivingEntity le = (LivingEntity)this.getBukkitEntity();
        EntityEquipment ee = le.getEquipment();
        assert (ee != null);
        ee.setHelmet(BukkitAdapter.adapt(item));
    }

    @Override
    public Optional<AbstractItemStack> getItemChest() {
        if (!this.isLiving()) {
            return Optional.empty();
        }
        EntityEquipment equipment = this.getEntityAsLiving().getEquipment();
        if (equipment == null) {
            return Optional.empty();
        }
        ItemStack item = equipment.getItem(EquipmentSlot.CHEST);
        return Optional.of(BukkitAdapter.adapt(item));
    }

    @Override
    public void equipItemChest(AbstractItemStack item) {
        if (!this.isLiving()) {
            return;
        }
        LivingEntity le = (LivingEntity)this.getBukkitEntity();
        EntityEquipment ee = le.getEquipment();
        assert (ee != null);
        ee.setChestplate(BukkitAdapter.adapt(item));
    }

    @Override
    public Optional<AbstractItemStack> getItemLegs() {
        if (!this.isLiving()) {
            return Optional.empty();
        }
        EntityEquipment equipment = this.getEntityAsLiving().getEquipment();
        if (equipment == null) {
            return Optional.empty();
        }
        ItemStack item = equipment.getItem(EquipmentSlot.LEGS);
        return Optional.of(BukkitAdapter.adapt(item));
    }

    @Override
    public void equipItemLegs(AbstractItemStack item) {
        if (!this.isLiving()) {
            return;
        }
        LivingEntity le = (LivingEntity)this.getBukkitEntity();
        EntityEquipment ee = le.getEquipment();
        assert (ee != null);
        ee.setLeggings(BukkitAdapter.adapt(item));
    }

    @Override
    public Optional<AbstractItemStack> getItemFeet() {
        if (!this.isLiving()) {
            return Optional.empty();
        }
        EntityEquipment equipment = this.getEntityAsLiving().getEquipment();
        if (equipment == null) {
            return Optional.empty();
        }
        ItemStack item = equipment.getItem(EquipmentSlot.FEET);
        return Optional.of(BukkitAdapter.adapt(item));
    }

    @Override
    public void equipItemFeet(AbstractItemStack item) {
        if (!this.isLiving()) {
            return;
        }
        LivingEntity le = (LivingEntity)this.getBukkitEntity();
        EntityEquipment ee = le.getEquipment();
        assert (ee != null);
        ee.setBoots(BukkitAdapter.adapt(item));
    }

    @Override
    public Optional<AbstractItemStack> getItemMainHand() {
        if (!this.isLiving()) {
            return Optional.empty();
        }
        EntityEquipment equipment = this.getEntityAsLiving().getEquipment();
        if (equipment == null) {
            return Optional.empty();
        }
        ItemStack item = equipment.getItem(EquipmentSlot.HAND);
        return Optional.of(BukkitAdapter.adapt(item));
    }

    @Override
    public void equipItemMainHand(AbstractItemStack item) {
        if (!this.isLiving()) {
            return;
        }
        LivingEntity le = (LivingEntity)this.getBukkitEntity();
        EntityEquipment ee = le.getEquipment();
        assert (ee != null);
        ee.setItemInMainHand(BukkitAdapter.adapt(item));
    }

    @Override
    public Optional<AbstractItemStack> getItemOffhand() {
        if (!this.isLiving()) {
            return Optional.empty();
        }
        EntityEquipment equipment = this.getEntityAsLiving().getEquipment();
        if (equipment == null) {
            return Optional.empty();
        }
        ItemStack item = equipment.getItem(EquipmentSlot.OFF_HAND);
        return Optional.of(BukkitAdapter.adapt(item));
    }

    @Override
    public void equipItemOffHand(AbstractItemStack item) {
        if (!this.isLiving()) {
            return;
        }
        LivingEntity le = (LivingEntity)this.getBukkitEntity();
        EntityEquipment ee = le.getEquipment();
        assert (ee != null);
        ee.setItemInOffHand(BukkitAdapter.adapt(item));
    }

    @Override
    public void setMovementSpeed(double speed) {
        if (!this.isLiving()) {
            return;
        }
        LivingEntity le = (LivingEntity)this.getBukkitEntity();
        le.getAttribute(BukkitAttribute.getAttribute("MOVEMENT_SPEED")).setBaseValue(speed);
    }

    @Override
    public void setAttackSpeed(double speed) {
        if (!this.isLiving()) {
            return;
        }
        LivingEntity le = (LivingEntity)this.getBukkitEntity();
        AttributeInstance attribute = le.getAttribute(BukkitAttribute.getAttribute("ATTACK_SPEED"));
        if (attribute == null) {
            try {
                MythicBukkit.inst().getVolatileCodeHandler().getEntityHandler().registerAttribute(this, BukkitAttribute.getAttribute("ATTACK_SPEED"));
            }
            catch (Exception e) {
                MythicLogger.debug(MythicLogger.DebugLevel.INFO, "Failed to register {0} attribute to entity", BukkitAttribute.getAttribute("ATTACK_SPEED"));
                return;
            }
        }
        le.getAttribute(BukkitAttribute.getAttribute("ATTACK_SPEED")).setBaseValue(speed);
    }

    @Override
    public int getLuck() {
        if (!this.isLiving()) {
            return 0;
        }
        LivingEntity le = (LivingEntity)this.getBukkitEntity();
        double luck = 0.0;
        if (le.getAttribute(BukkitAttribute.getAttribute("LUCK")) != null) {
            luck = le.getAttribute(BukkitAttribute.getAttribute("LUCK")).getValue();
        }
        if (le.getEquipment() != null) {
            luck += (double)le.getEquipment().getItemInMainHand().getEnchantmentLevel(VolatileEnchantment.LUCK_OF_THE_SEA);
        }
        for (PotionEffect pe : le.getActivePotionEffects()) {
            if (pe.getType() == PotionEffectType.LUCK) {
                luck += (double)pe.getAmplifier();
                continue;
            }
            if (pe.getType() != PotionEffectType.UNLUCK) continue;
            luck -= (double)pe.getAmplifier();
        }
        return (int)luck;
    }

    @Override
    public int getEnchantmentLevel(String enchantmentName) {
        Enchantment enchant;
        if (!this.isLiving()) {
            return 0;
        }
        try {
            enchant = Enchantment.getByName((String)enchantmentName);
        }
        catch (Exception ex) {
            return 0;
        }
        if (enchant == null) {
            return 0;
        }
        return this.getEnchantmentLevel(enchant);
    }

    public int getEnchantmentLevel(Enchantment enchant) {
        if (!this.isLiving()) {
            return 0;
        }
        LivingEntity le = (LivingEntity)this.getBukkitEntity();
        int level = 0;
        if (le.getEquipment() != null) {
            level += le.getEquipment().getItemInMainHand().getEnchantmentLevel(enchant);
            level += le.getEquipment().getItemInOffHand().getEnchantmentLevel(enchant);
            for (ItemStack item : le.getEquipment().getArmorContents()) {
                if (item == null) continue;
                level += item.getEnchantmentLevel(enchant);
            }
        }
        return level;
    }

    @Override
    public int getEnchantmentLevelHeld(String enchantmentName) {
        Enchantment enchant;
        if (!this.isLiving()) {
            return 0;
        }
        try {
            enchant = Enchantment.getByName((String)enchantmentName);
        }
        catch (Exception ex) {
            return 0;
        }
        if (enchant == null) {
            return 0;
        }
        return this.getEnchantmentLevelHeld(enchant);
    }

    public int getEnchantmentLevelHeld(Enchantment enchant) {
        if (!this.isLiving()) {
            return 0;
        }
        LivingEntity le = (LivingEntity)this.getBukkitEntity();
        return le.getEquipment().getItemInMainHand().getEnchantmentLevel(enchant);
    }

    @Override
    public void setMetadata(String key, Object value) {
        AbstractEntity parent;
        AbstractModelEngineSupport meg;
        if (this.meg().isPresent() && (meg = this.meg().get()).isSubHitbox(this.getUniqueId()) && (parent = meg.getParent(this)) != this) {
            parent.setMetadata(key, value);
            return;
        }
        Entity e = this.getBukkitEntity();
        e.setMetadata(key, (MetadataValue)new FixedMetadataValue((Plugin)MythicBukkit.inst(), value));
    }

    @Override
    public boolean hasMetadata(String key) {
        Entity e = this.getBukkitEntity();
        return e.hasMetadata(key) || this.meg().map(meg -> {
            AbstractEntity parent;
            if (meg.isSubHitbox(this.getUniqueId()) && (parent = meg.getParent(this)) != this) {
                return parent.hasMetadata(key);
            }
            return false;
        }).orElse(false) != false;
    }

    @Override
    public void removeMetadata(String key) {
        AbstractEntity parent;
        AbstractModelEngineSupport meg;
        if (this.meg().isPresent() && (meg = this.meg().get()).isSubHitbox(this.getUniqueId()) && (parent = meg.getParent(this)) != this) {
            parent.removeMetadata(key);
        }
        Entity e = this.getBukkitEntity();
        e.removeMetadata(key, (Plugin)MythicBukkit.inst());
    }

    @Override
    public synchronized boolean isLoaded() {
        Entity e = this.getBukkitEntity();
        return e.getLocation().getChunk().isLoaded();
    }

    @Override
    public Optional<Object> getMetadata(String key) {
        AbstractEntity parent;
        AbstractModelEngineSupport meg;
        if (this.meg().isPresent() && (meg = this.meg().get()).isSubHitbox(this.getUniqueId()) && (parent = meg.getParent(this)) != this) {
            return parent.getMetadata(key);
        }
        Entity e = this.getBukkitEntity();
        List values = e.getMetadata(key);
        if (values.size() > 1) {
            for (MetadataValue mv : values) {
                if (!mv.getOwningPlugin().equals((Object)MythicBukkit.inst())) continue;
                return Optional.of(mv.value());
            }
        } else if (values.size() == 1) {
            return Optional.of(((MetadataValue)values.get(0)).value());
        }
        return Optional.empty();
    }

    @Override
    public AbstractVector getVelocity() {
        Entity e = this.getBukkitEntity();
        if (e == null) {
            return new AbstractVector(0, 0, 0);
        }
        return BukkitAdapter.adapt(e.getVelocity());
    }

    @Override
    public void setVelocity(AbstractVector velocity) {
        Entity e = this.getBukkitEntity();
        Vector v = BukkitAdapter.adapt(velocity);
        e.setVelocity(v);
    }

    @Override
    public AbstractVector getMotion() {
        return MythicBukkit.inst().getVolatileCodeHandler().getEntityHandler().getEntityMotion(this);
    }

    @Override
    public boolean isOnGround() {
        return this.getBukkitEntity().isOnGround();
    }

    @Override
    public void setFreezingTicks(int i) {
        this.getBukkitEntity().setFreezeTicks(i);
    }

    @Override
    public boolean isFreezing() {
        return this.getBukkitEntity().getFreezeTicks() > 0;
    }

    @Override
    public int getFreezingTicks() {
        return this.getBukkitEntity().getFreezeTicks();
    }

    @Override
    public int getMaxFreezingTicks() {
        return this.getBukkitEntity().getMaxFreezeTicks();
    }

    @Override
    public void setSavesToDisk(boolean b) {
        this.getBukkitEntity().setPersistent(b);
    }

    private Optional<AbstractModelEngineSupport> meg() {
        return MythicBukkit.inst().getCompatibility().getModelEngine();
    }
}

