/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.adapters;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractGameMode;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.adapters.BukkitEntity;
import io.lumine.mythic.bukkit.utils.text.Text;
import java.time.Duration;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import net.kyori.adventure.util.Ticks;
import org.bukkit.GameMode;
import org.bukkit.WeatherType;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class BukkitPlayer
extends BukkitEntity
implements AbstractPlayer {
    public BukkitPlayer(Player p) {
        super((Entity)p);
    }

    @Override
    public boolean isInCreativeMode() {
        return this.getEntityAsPlayer().getGameMode().equals((Object)GameMode.CREATIVE);
    }

    @Override
    public boolean isInSpectatorMode() {
        return this.getEntityAsPlayer().getGameMode().equals((Object)GameMode.SPECTATOR);
    }

    @Override
    public void sendMessage(String message) {
        Text.sendMessage((CommandSender)this.getBukkitEntity(), message);
    }

    @Override
    public void sendActionBarMessage(String message) {
        Text.sendActionBar((CommandSender)this.getBukkitEntity(), message);
    }

    @Override
    public void sendTitle(String title, String subTitle, int fadeIn, int stayTime, int fadeOut) {
        Audience.audience((Audience[])new Audience[]{this.getEntityAsPlayer()}).showTitle(Title.title((Component)Text.parse(title), (Component)Text.parse(subTitle), (Title.Times)Title.Times.times((Duration)Ticks.duration((long)fadeIn), (Duration)Ticks.duration((long)stayTime), (Duration)Ticks.duration((long)fadeOut))));
    }

    @Override
    public boolean hasPermission(String perm) {
        return this.getEntityAsPlayer().hasPermission(perm);
    }

    @Override
    public float getExperience() {
        return this.getEntityAsPlayer().getExp();
    }

    @Override
    public void setExperience(float exp) {
        this.getEntityAsPlayer().setExp(exp);
    }

    @Override
    public void hidePlayer(AbstractPlayer target) {
        this.getEntityAsPlayer().hidePlayer((Player)target.getBukkitEntity());
    }

    @Override
    public void hideEntity(AbstractEntity target) {
        this.getEntityAsPlayer().hideEntity((Plugin)MythicBukkit.inst(), target.getBukkitEntity());
    }

    @Override
    public void showPlayer(AbstractPlayer target) {
        this.getEntityAsPlayer().showPlayer((Player)target.getBukkitEntity());
    }

    @Override
    public void showEntity(AbstractEntity target) {
        this.getEntityAsPlayer().showEntity((Plugin)MythicBukkit.inst(), target.getBukkitEntity());
    }

    @Override
    public boolean canSee(AbstractPlayer target) {
        return this.getEntityAsPlayer().canSee((Player)target.getBukkitEntity());
    }

    @Override
    public boolean canSee(AbstractEntity target) {
        return this.getEntityAsPlayer().canSee(target.getBukkitEntity());
    }

    @Override
    public boolean isOnline() {
        return this.getEntityAsPlayer().isOnline();
    }

    @Override
    public int getLevel() {
        return this.getEntityAsPlayer().getLevel();
    }

    @Override
    public void setLevel(int level) {
        this.getEntityAsPlayer().setLevel(level);
    }

    @Override
    public void setHealthScale(double scale) {
        this.getEntityAsPlayer().setHealthScale(scale);
    }

    @Override
    public void setHealthScaled(boolean scale) {
        this.getEntityAsPlayer().setHealthScaled(scale);
    }

    @Override
    public void setPersonalTime(long time, boolean relative) {
        this.getEntityAsPlayer().setPlayerTime(time, relative);
    }

    @Override
    public void resetPersonalTime() {
        this.getEntityAsPlayer().resetPlayerTime();
    }

    @Override
    public void setPersonalWeather(String type) {
        this.getEntityAsPlayer().setPlayerWeather(WeatherType.valueOf((String)type.toUpperCase()));
    }

    @Override
    public void resetPersonalWeather() {
        this.getEntityAsPlayer().resetPlayerWeather();
    }

    @Override
    public void setAllowFlight(boolean b) {
        this.getEntityAsPlayer().setAllowFlight(b);
    }

    @Override
    public boolean getAllowFlight() {
        return this.getEntityAsPlayer().getAllowFlight();
    }

    @Override
    public void setFlying(boolean b) {
        this.getEntityAsPlayer().setFlying(b);
    }

    @Override
    public void setFlyingSpeed(float f) {
        this.getEntityAsPlayer().setFlySpeed(f);
    }

    @Override
    public void setWalkSpeed(float f) {
        this.getEntityAsPlayer().setWalkSpeed(f);
    }

    @Override
    public int getFoodLevel() {
        return this.getEntityAsPlayer().getFoodLevel();
    }

    @Override
    public void setFoodLevel(int amount) {
        this.getEntityAsPlayer().setFoodLevel(amount);
    }

    @Override
    public float getFoodSaturation() {
        return this.getEntityAsPlayer().getSaturation();
    }

    @Override
    public void setFoodSaturation(float amount) {
        this.getEntityAsPlayer().setSaturation(amount);
    }

    @Override
    public int getRemainingAir() {
        return this.getEntityAsPlayer().getRemainingAir();
    }

    @Override
    public void setRemainingAir(int ticks) {
        this.getEntityAsPlayer().setRemainingAir(ticks);
    }

    @Override
    public int getMaximumAir() {
        return this.getEntityAsPlayer().getMaximumAir();
    }

    @Override
    public void setMaximumAir(int ticks) {
        this.getEntityAsPlayer().setMaximumAir(ticks);
    }

    @Override
    public void setGameMode(AbstractGameMode mode) {
        switch (mode) {
            case ADVENTURE: {
                this.getEntityAsPlayer().setGameMode(GameMode.ADVENTURE);
                break;
            }
            case CREATIVE: {
                this.getEntityAsPlayer().setGameMode(GameMode.CREATIVE);
                break;
            }
            case SPECTATOR: {
                this.getEntityAsPlayer().setGameMode(GameMode.SPECTATOR);
                break;
            }
            case SURVIVAL: {
                this.getEntityAsPlayer().setGameMode(GameMode.SURVIVAL);
                break;
            }
        }
    }

    @Override
    public AbstractGameMode getGameMode() {
        GameMode bukkitMode = this.getEntityAsPlayer().getGameMode();
        switch (bukkitMode) {
            case ADVENTURE: {
                return AbstractGameMode.ADVENTURE;
            }
            case CREATIVE: {
                return AbstractGameMode.CREATIVE;
            }
            case SPECTATOR: {
                return AbstractGameMode.SPECTATOR;
            }
        }
        return AbstractGameMode.SURVIVAL;
    }

    @Override
    public void updateInventory() {
        this.getEntityAsPlayer().updateInventory();
    }

    @Override
    public int getFortuneLevel() {
        return this.getEnchantmentLevelHeld(Enchantment.FORTUNE);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof BukkitPlayer)) {
            return false;
        }
        return ((BukkitPlayer)o).getUniqueId().equals(this.getUniqueId());
    }

    @Override
    public int hashCode() {
        return this.getUniqueId().hashCode();
    }
}

