/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.adapters.item;

import io.lumine.mythic.api.adapters.AbstractItemStack;
import io.lumine.mythic.api.adapters.items.components.AbstractItemConsumableComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemFoodComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemPotionComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemTooltipComponent;
import io.lumine.mythic.api.drops.DropMetadata;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.adapters.BukkitItemStack;
import io.lumine.mythic.bukkit.adapters.BukkitPotionEffect;
import io.lumine.mythic.bukkit.adapters.item.ItemComponentBukkitItemStack;
import io.lumine.mythic.bukkit.utils.version.MinecraftVersions;
import io.lumine.mythic.bukkit.utils.version.ServerVersion;
import io.papermc.paper.datacomponent.DataComponentBuilder;
import io.papermc.paper.datacomponent.DataComponentType;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.Consumable;
import io.papermc.paper.datacomponent.item.FoodProperties;
import io.papermc.paper.datacomponent.item.PotionContents;
import io.papermc.paper.datacomponent.item.consumable.ItemUseAnimation;
import java.util.Locale;
import java.util.function.Consumer;
import net.kyori.adventure.key.Key;
import org.bukkit.Bukkit;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemComponentPaperItemStack
extends ItemComponentBukkitItemStack {
    public ItemComponentPaperItemStack(ItemStack itemStack) {
        super(itemStack);
    }

    @Override
    public BukkitItemStack clone() {
        return new ItemComponentPaperItemStack(this.itemStack.clone());
    }

    @Override
    public ItemComponentPaperItemStack editMeta(Consumer<ItemMeta> block) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta == null) {
            meta = Bukkit.getItemFactory().getItemMeta(this.itemStack.getType());
        }
        if (meta == null) {
            return this;
        }
        block.accept(meta);
        this.itemStack.setItemMeta(meta);
        return this;
    }

    @Override
    public ItemComponentPaperItemStack applyFoodComponent(AbstractItemFoodComponent foodData) {
        FoodProperties.Builder foodBuilder = this.itemStack.hasData((DataComponentType)DataComponentTypes.FOOD) ? (FoodProperties.Builder)((FoodProperties)this.itemStack.getData(DataComponentTypes.FOOD)).toBuilder() : FoodProperties.food();
        if (foodData.getCanAlwaysEat() != null) {
            foodBuilder.canAlwaysEat(foodData.getCanAlwaysEat().booleanValue());
        }
        if (foodData.getNutrition() != null) {
            foodBuilder.nutrition(foodData.getNutrition().intValue());
        }
        if (foodData.getSaturation() != null) {
            foodBuilder.saturation(foodData.getSaturation().floatValue());
        }
        this.itemStack.setData(DataComponentTypes.FOOD, (Object)((FoodProperties)foodBuilder.build()));
        return this;
    }

    @Override
    public ItemComponentPaperItemStack applyConsumableComponent(AbstractItemConsumableComponent consumableData) {
        Consumable.Builder consumableBuilder = this.itemStack.hasData((DataComponentType)DataComponentTypes.CONSUMABLE) ? (Consumable.Builder)((Consumable)this.itemStack.getData(DataComponentTypes.CONSUMABLE)).toBuilder() : Consumable.consumable();
        if (consumableData.getConsumeSeconds() != null) {
            consumableBuilder.consumeSeconds(consumableData.getConsumeSeconds().floatValue());
        }
        if (consumableData.getHasConsumeParticles() != null) {
            consumableBuilder.hasConsumeParticles(consumableData.getHasConsumeParticles().booleanValue());
        }
        if (consumableData.getAnimation() != null) {
            try {
                ItemUseAnimation animation = ItemUseAnimation.valueOf((String)consumableData.getAnimation());
                consumableBuilder.animation(animation);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
        if (consumableData.getSound() != null) {
            Object soundKey = consumableData.getSound().toLowerCase(Locale.ROOT);
            if (!((String)soundKey).contains(":")) {
                soundKey = "minecraft:" + (String)soundKey;
            }
            consumableBuilder.sound(Key.key((String)soundKey));
        }
        this.itemStack.setData(DataComponentTypes.CONSUMABLE, (Object)((Consumable)consumableBuilder.build()));
        return this;
    }

    @Override
    public ItemComponentPaperItemStack applyPotionComponent(DropMetadata dropMetadata, AbstractItemPotionComponent potionData) {
        PotionContents.Builder potionComponent = PotionContents.potionContents();
        if (potionData.getCustomName() != null) {
            potionComponent.customName(potionData.getCustomName().get(dropMetadata));
        }
        if (potionData.getPotionColor() != null) {
            potionComponent.customColor(potionData.getPotionColor().get(dropMetadata).toBukkitColor());
        }
        for (BukkitPotionEffect effect : potionData.getEffects()) {
            potionComponent.addCustomEffect(effect.getEffect());
        }
        this.itemStack.setData(DataComponentTypes.POTION_CONTENTS, (DataComponentBuilder)potionComponent);
        return this;
    }

    @Override
    public ItemComponentPaperItemStack copy() {
        return new ItemComponentPaperItemStack(this.itemStack.clone());
    }

    @Override
    public AbstractItemStack applyTooltipComponent(AbstractItemTooltipComponent abstractItemTooltipComponent) {
        if (ServerVersion.isPaper() && ServerVersion.isAfterOrEq(MinecraftVersions.v1_21_3)) {
            String tooltipStyle = abstractItemTooltipComponent.getTooltipStyle();
            if (tooltipStyle == null) {
                return this;
            }
            Key tooltipKey = !tooltipStyle.contains(":") ? (MythicBukkit.inst().getCompatibility().getCrucible().isPresent() && MythicBukkit.inst().getCompatibility().getCrucible().get().isGeneratedTooltip(tooltipStyle) ? Key.key((String)"mythic", (String)tooltipStyle) : Key.key((String)"minecraft", (String)tooltipStyle)) : Key.key((String)tooltipStyle);
            this.itemStack.setData(DataComponentTypes.TOOLTIP_STYLE, (Object)tooltipKey);
        }
        return this;
    }
}

