/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.commands;

import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.commands.CommandHelper;
import io.lumine.mythic.bukkit.events.MythicPostReloadedEvent;
import io.lumine.mythic.bukkit.events.MythicPreReloadEvent;
import io.lumine.mythic.bukkit.events.MythicReloadedEvent;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.commands.Command;
import io.lumine.mythic.core.config.MythicLang;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.players.PlayerData;
import java.util.Arrays;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class ReloadCommand
extends Command<MythicBukkit> {
    boolean reloading = false;

    public ReloadCommand(Command<MythicBukkit> parent) {
        super(parent);
    }

    @Override
    public boolean onCommand(CommandSender sender, String[] args) {
        if (this.reloading) {
            CommandHelper.sendError(sender, "Plugin is already reloading...");
            return true;
        }
        boolean optSync = true;
        if (args != null && args.length > 0 && args[0].startsWith("-")) {
            if (args[0].startsWith("-a")) {
                optSync = false;
            }
            args = Arrays.copyOfRange(args, 1, args.length);
        }
        if (((MythicBukkit)this.plugin).getConfiguration().getAnnounceOpReload().booleanValue()) {
            if (!sender.isOp()) {
                CommandHelper.sendSuccess(sender, MythicLang.get("command.reload.started", "Reloading plugin...", new Object[0]));
            }
            for (Player player : ((MythicBukkit)this.plugin).getServer().getOnlinePlayers()) {
                if (!player.isOp()) continue;
                CommandHelper.sendSuccess((CommandSender)player, MythicLang.get("command.reload.started", "Reloading plugin...", new Object[0]));
            }
        } else {
            CommandHelper.sendSuccess(sender, MythicLang.get("command.reload.started", "Reloading plugin...", new Object[0]));
        }
        this.reloading = true;
        try {
            MythicPreReloadEvent event = new MythicPreReloadEvent((MythicBukkit)this.plugin);
            ((MythicBukkit)this.plugin).getServer().getPluginManager().callEvent((Event)event);
        }
        catch (Error | Exception ex) {
            CommandHelper.sendError(sender, "An error occurred while reloading!");
            ex.printStackTrace();
        }
        ((MythicBukkit)this.getPlugin()).getClock().unload();
        if (optSync) {
            ((MythicBukkit)this.getPlugin()).getPlaceholderManager().setAcceptingRegisteredParsers(true);
            this.doReloadPart1(sender);
            this.doReloadPart2(sender);
            ((MythicBukkit)this.getPlugin()).getPlaceholderManager().setAcceptingRegisteredParsers(false);
        } else {
            Schedulers.async().run(() -> {
                ((MythicBukkit)this.getPlugin()).getPlaceholderManager().setAcceptingRegisteredParsers(true);
                this.doReloadPart1(sender);
                Schedulers.sync().run(() -> {
                    this.doReloadPart2(sender);
                    ((MythicBukkit)this.getPlugin()).getPlaceholderManager().setAcceptingRegisteredParsers(false);
                });
            });
        }
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, String[] args) {
        return null;
    }

    @Override
    public String getPermissionNode() {
        return "mythicmobs.command.reload";
    }

    @Override
    public boolean isConsoleFriendly() {
        return true;
    }

    @Override
    public String getName() {
        return "reload";
    }

    @Override
    public String[] getAliases() {
        return new String[]{"r", "re"};
    }

    private void doReloadPart1(CommandSender sender) {
        try {
            ((MythicBukkit)this.plugin).getConfiguration().reload();
        }
        catch (Error | Exception ex) {
            CommandHelper.sendError(sender, "An error occurred while reloading!");
            ex.printStackTrace();
        }
    }

    private void doReloadPart2(CommandSender sender) {
        Event event;
        try {
            for (ActiveMob am : ((MythicBukkit)this.getPlugin()).getMobManager().getActiveMobs()) {
                am.remountSpawner();
                am.remountType();
                am.getStatRegistry().refresh();
            }
        }
        catch (Error | Exception ex) {
            CommandHelper.sendError(sender, "An error occurred while reloading active mobs!");
            ex.printStackTrace();
        }
        try {
            for (PlayerData profile : ((MythicBukkit)this.getPlugin()).getPlayerManager().getKnownProfiles()) {
                profile.getStatRegistry().refresh();
            }
        }
        catch (Error | Exception ex) {
            CommandHelper.sendError(sender, "An error occurred while reloading player data!");
            ex.printStackTrace();
        }
        ((MythicBukkit)this.getPlugin()).getClock().load((MythicBukkit)this.getPlugin());
        this.reloading = false;
        try {
            event = new MythicReloadedEvent((MythicBukkit)this.plugin);
            ((MythicBukkit)this.plugin).getServer().getPluginManager().callEvent(event);
        }
        catch (Error | Exception ex) {
            CommandHelper.sendError(sender, "An error occurred while reloading!");
            ex.printStackTrace();
        }
        try {
            event = new MythicPostReloadedEvent((MythicBukkit)this.plugin);
            ((MythicBukkit)this.plugin).getServer().getPluginManager().callEvent(event);
        }
        catch (Error | Exception ex) {
            CommandHelper.sendError(sender, "An error occurred while reloading!");
            ex.printStackTrace();
        }
        ((MythicBukkit)this.getPlugin()).getClock().runPostReload();
        if (((MythicBukkit)this.plugin).getConfiguration().getAnnounceOpReload().booleanValue()) {
            if (!sender.isOp()) {
                CommandHelper.sendSuccess(sender, MythicLang.get("command.reload.completed", "Mythic has finished reloading!", new Object[0]));
            }
            for (Player player : ((MythicBukkit)this.plugin).getServer().getOnlinePlayers()) {
                if (!player.isOp()) continue;
                CommandHelper.sendSuccess((CommandSender)player, MythicLang.get("command.reload.completed", "Mythic has finished reloading!", new Object[0]));
            }
        } else {
            CommandHelper.sendSuccess(sender, MythicLang.get("command.reload.completed", "Mythic has finished reloading!", new Object[0]));
        }
        MythicLogger.log(MythicLang.get("command.reload.completed", "Mythic has finished reloading!", new Object[0]));
    }
}

