/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.commands.items;

import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.commands.CommandHelper;
import io.lumine.mythic.bukkit.events.MythicApplyEnchantEvent;
import io.lumine.mythic.bukkit.utils.CollectionUtils;
import io.lumine.mythic.bukkit.utils.Events;
import io.lumine.mythic.bukkit.utils.commands.Command;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class EnchantCommand
extends Command<MythicBukkit> {
    public EnchantCommand(Command<MythicBukkit> parent) {
        super(parent);
    }

    @Override
    public boolean onCommand(CommandSender sender, String[] args) {
        Player p;
        ItemStack item;
        if (args == null || args.length == 0) {
            CommandHelper.sendError(sender, "Syntax: /mm item enchant <name> [level]");
            return true;
        }
        String enchantment = args[0];
        int level = 1;
        if (args.length > 1) {
            try {
                level = Integer.valueOf(args[1]);
            }
            catch (Exception ex) {
                CommandHelper.sendError(sender, "Level must be an integer.");
                return true;
            }
        }
        if ((item = (p = (Player)sender).getInventory().getItemInMainHand()) == null || item.getType().equals((Object)Material.AIR)) {
            CommandHelper.sendError(sender, "You must be holding a valid item!");
            return true;
        }
        Enchantment en = Enchantment.getByName((String)enchantment);
        if (en == null) {
            CommandHelper.sendError(sender, "You must enter a valid enchantment name!");
            return true;
        }
        MythicApplyEnchantEvent event = new MythicApplyEnchantEvent(item, en, level);
        if ((event = Events.callAndReturn(event)).getWasHandled().booleanValue()) {
            CommandHelper.sendSuccess(sender, "Applied enchantment to held item!");
            return true;
        }
        if (item.getType() != Material.ENCHANTED_BOOK) {
            item.addUnsafeEnchantment(en, level);
        } else {
            EnchantmentStorageMeta esm = (EnchantmentStorageMeta)item.getItemMeta();
            esm.addStoredEnchant(en, level, true);
            item.setItemMeta((ItemMeta)esm);
        }
        CommandHelper.sendSuccess(sender, "Applied enchantment to held item!");
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, String[] args) {
        if (args.length == 1) {
            ArrayList<String> enchants = new ArrayList<String>();
            for (Enchantment ench : Enchantment.values()) {
                enchants.add(ench.getName());
            }
            return CollectionUtils.filterMatches(args[0], enchants, 2);
        }
        return null;
    }

    @Override
    public String getPermissionNode() {
        return "mythicmobs.command.items.enchant";
    }

    @Override
    public boolean isConsoleFriendly() {
        return false;
    }

    @Override
    public String getName() {
        return "enchant";
    }

    @Override
    public String[] getAliases() {
        return new String[]{"ench", "e"};
    }
}

