/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.entities;

import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.mobs.entities.SpawnReason;
import io.lumine.mythic.bukkit.adapters.BukkitEntityType;
import io.lumine.mythic.bukkit.entities.properties.AgeableProperty;
import io.lumine.mythic.bukkit.entities.properties.MerchantProperty;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.WanderingTrader;

public class BukkitWanderingTrader
extends BukkitEntityType {
    private static final int height = 2;
    private AgeableProperty ageableProperty;
    private MerchantProperty merchantProperty;

    @Override
    public void instantiate(MythicConfig mc) {
        this.ageableProperty = new AgeableProperty(mc);
        this.merchantProperty = new MerchantProperty(mc);
    }

    @Override
    public Entity spawn(Location location, SpawnReason reason, Consumer<Entity> prespawnFunc) {
        return this.spawnEntity(location, EntityType.WANDERING_TRADER, reason, prespawnFunc);
    }

    @Override
    public Entity applyOptions(Entity entity) {
        WanderingTrader e = (WanderingTrader)entity;
        this.ageableProperty.applyProperties(entity);
        this.merchantProperty.applyProperties(entity);
        return e;
    }

    @Override
    public boolean compare(Entity e) {
        return e instanceof WanderingTrader;
    }

    @Override
    public int getHeight() {
        return 2;
    }
}

