/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.entities;

import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.mobs.entities.SpawnReason;
import io.lumine.mythic.api.volatilecode.VolatileAttribute;
import io.lumine.mythic.bukkit.adapters.BukkitEntityType;
import io.lumine.mythic.bukkit.utils.items.ItemFactory;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Zombie;
import org.bukkit.inventory.ItemStack;

public class BukkitZombie
extends BukkitEntityType {
    private final int height = 2;
    private final String headString = "";
    private final ItemStack head = ItemFactory.of(Material.ZOMBIE_HEAD).build();
    private double reinforcementChance = -1.0;
    private boolean preventConversion = false;

    @Override
    public void instantiate(MythicConfig mc) {
        this.reinforcementChance = mc.getDouble("Options.ReinforcementsChance", -1.0);
        this.preventConversion = mc.getBoolean("Options.PreventConversion", false);
    }

    @Override
    public Entity spawn(Location location, SpawnReason reason, Consumer<Entity> prespawnFunc) {
        Zombie e = (Zombie)this.spawnEntity(location, EntityType.ZOMBIE, reason, prespawnFunc);
        e.setBaby(false);
        return e;
    }

    @Override
    public Entity applyOptions(Entity entity) {
        Zombie e = (Zombie)entity;
        if (this.reinforcementChance >= 0.0) {
            e.getAttribute(VolatileAttribute.SPAWN_REINFORCEMENTS).setBaseValue(this.reinforcementChance);
        }
        if (this.preventConversion) {
            e.setConversionTime(Integer.MAX_VALUE);
        }
        return e;
    }

    @Override
    public boolean compare(Entity e) {
        return BukkitZombie.isInstanceOf(e);
    }

    public static boolean isInstanceOf(Entity e) {
        return e instanceof Zombie;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public String getHeadString() {
        return this.headString;
    }

    @Override
    public ItemStack getHead() {
        return this.head;
    }
}

