/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.listeners;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.api.mobs.entities.MythicEntityType;
import io.lumine.mythic.api.mobs.entities.SpawnReason;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.adapters.BukkitEntityType;
import io.lumine.mythic.bukkit.entities.BukkitSilverfish;
import io.lumine.mythic.bukkit.entities.BukkitSnowman;
import io.lumine.mythic.bukkit.events.MythicDamageEvent;
import io.lumine.mythic.bukkit.utils.Events;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.plugin.ReloadableModule;
import io.lumine.mythic.bukkit.utils.version.MinecraftVersions;
import io.lumine.mythic.bukkit.utils.version.ServerVersion;
import io.lumine.mythic.core.constants.MobKeys;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.mobs.DespawnMode;
import io.lumine.mythic.core.mobs.MobExecutor;
import io.lumine.mythic.core.mobs.PersistentMobData;
import io.lumine.mythic.core.mobs.WorldScaling;
import io.lumine.mythic.core.skills.SkillTriggers;
import io.lumine.mythic.core.skills.TriggeredSkill;
import io.lumine.mythic.core.skills.triggers.meta.EntityAttackMetadata;
import io.lumine.mythic.core.spawning.random.RandomSpawnPoint;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Interaction;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Slime;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.EntityBlockFormEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityCombustByBlockEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageByBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.PlayerLeashEntityEvent;
import org.bukkit.event.entity.SlimeSplitEvent;
import org.bukkit.event.player.PlayerArmorStandManipulateEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.EntitiesLoadEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.potion.PotionEffect;
import org.bukkit.projectiles.ProjectileSource;

public class MobListeners
extends ReloadableModule<MythicBukkit>
implements Listener {
    public MobListeners(MythicBukkit plugin) {
        super(plugin);
    }

    @Override
    public void load(MythicBukkit plugin) {
        Events.subscribe(PlayerArmorStandManipulateEvent.class).handler(event -> {
            ActiveMob am;
            MythicLogger.debug(MythicLogger.DebugLevel.EVENT, "PlayerArmorStandManipulateEvent fired", new Object[0]);
            Optional<ActiveMob> maybeMob = ((MythicBukkit)this.getPlugin()).getMobManager().getActiveMob(event.getRightClicked().getUniqueId());
            if (maybeMob.isPresent() && !(am = maybeMob.get()).getType().getIsInteractable()) {
                event.setCancelled(true);
            }
        }).bindWith(this);
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_19_4)) {
            Events.subscribe(EntityDamageByEntityEvent.class).filter(event -> event.getEntity() instanceof Interaction).handler(event -> ((MythicBukkit)this.getPlugin()).getMobManager().getActiveMob(event.getEntity().getUniqueId()).ifPresent(am -> {
                AbstractEntity damager = BukkitAdapter.adapt(event.getDamager());
                AbstractLocation origin = am.getLocation();
                SkillMetadata damageMetadata = ((MythicBukkit)this.getPlugin()).getSkillManager().getEventBus().buildSkillMetadata(SkillTriggers.DAMAGED, (SkillCaster)am, damager, origin, true);
                EntityAttackMetadata triggerMetadata = new EntityAttackMetadata((EntityDamageByEntityEvent)event, null, damager, am.getEntity());
                TriggeredSkill ts = ((MythicBukkit)this.getPlugin()).getSkillManager().getEventBus().processTriggerMechanics(damageMetadata, triggerMetadata);
                if (ts.getCancelled()) {
                    event.setCancelled(true);
                }
            })).bindWith(this);
        }
        Events.subscribe(SlimeSplitEvent.class, EventPriority.HIGH).handler(event -> {
            Slime entity = event.getEntity();
            if (entity.getPersistentDataContainer().has(PersistentMobData.SLIME_NO_SPLIT)) {
                event.setCancelled(true);
                event.setCount(0);
            }
        }).bindWith(this);
        Events.subscribe(CreatureSpawnEvent.class, EventPriority.HIGHEST).handler(event -> {
            List passengers;
            if (((MythicBukkit)this.getPlugin()).getConfiguration().isDebugMode()) {
                return;
            }
            if (((MythicBukkit)this.getPlugin()).getCompatibility().getWorldGuard().isPresent() && !((MythicBukkit)this.getPlugin()).getCompatibility().getWorldGuard().get().getLocationAllowsMobSpawning(event.getLocation())) {
                return;
            }
            MythicLogger.debug(MythicLogger.DebugLevel.EVENT, "CreatureSpawnEvent fired", new Object[0]);
            LivingEntity entity = event.getEntity();
            AbstractEntity aEntity = BukkitAdapter.adapt((Entity)entity);
            if (event.getSpawnReason() == CreatureSpawnEvent.SpawnReason.NATURAL || event.getSpawnReason() == CreatureSpawnEvent.SpawnReason.CHUNK_GEN) {
                if (((MythicBukkit)this.getPlugin()).getConfiguration().isVanillaSpawnsDisabled() && !BukkitEntityType.getIsSpawning().booleanValue()) {
                    event.setCancelled(true);
                }
            } else if (event.getSpawnReason() == CreatureSpawnEvent.SpawnReason.MOUNT && !(passengers = event.getEntity().getPassengers()).isEmpty()) {
                MobExecutor mobExecutor = ((MythicBukkit)this.getPlugin()).getMobManager();
                Schedulers.sync().runLater(() -> {
                    if (mobExecutor.isActiveMob(((Entity)passengers.get(0)).getUniqueId()) && !mobExecutor.isActiveMob(aEntity) && mobExecutor.getMythicMobInstance((Entity)passengers.get(0)).getType().getPreventMounts().booleanValue()) {
                        aEntity.remove();
                        return;
                    }
                }, 1L);
            }
            RandomSpawnPoint rsp = new RandomSpawnPoint(BukkitAdapter.adapt((Entity)event.getEntity()), BukkitAdapter.adapt(event.getLocation()), event.getSpawnReason());
            Entity ee = BukkitAdapter.adapt(((MythicBukkit)this.getPlugin()).getRandomSpawningManager().handleSpawnEvent(rsp));
            if (ee != null) {
                event.setCancelled(true);
            } else if (event.getSpawnReason() != CreatureSpawnEvent.SpawnReason.BREEDING && !BukkitEntityType.getIsSpawning().booleanValue()) {
                if (entity.getPersistentDataContainer().has(MobKeys.TYPE)) {
                    String mobType = (String)entity.getPersistentDataContainer().get(MobKeys.TYPE, PersistentDataType.STRING);
                    Optional<MythicMob> maybeMob = ((MythicBukkit)this.getPlugin()).getMobManager().getMythicMob(mobType);
                    if (maybeMob.isPresent()) {
                        MythicMob mm4 = maybeMob.get();
                        double level = WorldScaling.getLevelBonus(aEntity.getLocation());
                        ActiveMob am = ((MythicBukkit)this.getPlugin()).getMobManager().registerActiveMob(aEntity, mm4, level);
                        mm4.applyMobOptions(am, level);
                        mm4.applySpawnModifiers(am);
                        return;
                    }
                }
                MythicEntityType met = ((MythicBukkit)this.getPlugin()).getBootstrap().getMythicEntityType((Entity)event.getEntity());
                Optional<MythicMob> maybeType = ((MythicBukkit)this.getPlugin()).getMobManager().getVanillaType(met);
                if (maybeType.isPresent()) {
                    MythicMob mm5 = maybeType.get();
                    double level = WorldScaling.getLevelBonus(aEntity.getLocation());
                    ActiveMob am = ((MythicBukkit)this.getPlugin()).getMobManager().registerActiveMob(aEntity, mm5, level);
                    BukkitEntityType entityType = mm5.getMythicEntity();
                    if (entityType.compare((Entity)event.getEntity())) {
                        mm5.getMythicEntity().applyOptions((Entity)event.getEntity());
                    } else {
                        MythicLogger.error(event.getEntity().getType().toString() + " found with mobtype '" + mm5.getInternalName() + "' but does not match.");
                    }
                    mm5.applyMobOptions(am, level);
                    mm5.applyMobVolatileOptions(am);
                    mm5.applySpawnModifiers(am);
                } else {
                    WorldScaling worldScaling = WorldScaling.get(aEntity.getLocation().getWorld().getName());
                    if (worldScaling.getScaleVanillaMobs()) {
                        double level = WorldScaling.getLevelBonus(aEntity.getLocation());
                        if (((MythicBukkit)this.getPlugin()).getConfiguration().getScalingEquationHealth() != null) {
                            double newHealth = ((MythicBukkit)this.getPlugin()).getConfiguration().getScalingEquationHealth().setVariable("v", aEntity.getHealth()).setVariable("l", level).evaluate();
                            aEntity.setMaxHealth(newHealth);
                            aEntity.setHealth(newHealth);
                        }
                        if (((MythicBukkit)this.getPlugin()).getConfiguration().getScalingEquationDamage() != null && aEntity.getDamageBase() > 0.0) {
                            double newDamage = ((MythicBukkit)this.getPlugin()).getConfiguration().getScalingEquationDamage().setVariable("v", aEntity.getDamageBase()).setVariable("l", level).evaluate();
                            aEntity.setDamage(newDamage);
                        }
                    }
                }
            }
            if (event.getSpawnReason() == CreatureSpawnEvent.SpawnReason.CUSTOM) {
                if (plugin.getConfiguration().getUseCompatibilityMode().booleanValue()) {
                    l = event.getEntity();
                    Schedulers.sync().runLater(() -> {
                        if (!((MythicBukkit)this.getPlugin()).getMobManager().isActiveMob(aEntity.getUniqueId())) {
                            MythicLogger.debug(MythicLogger.DebugLevel.INFO, "Compatibility mode enabled and found custom mob spawn! Checking for MythicMob '" + l.getCustomName() + "'...", new Object[0]);
                            MythicMob mm4 = ((MythicBukkit)this.getPlugin()).getMobManager().getMythicMobByDisplayCompat(aEntity);
                            if (mm4 != null) {
                                ((MythicBukkit)this.getPlugin()).getMobManager().SetupMythicMobCompat(l, mm4);
                            } else {
                                ((MythicBukkit)this.getPlugin()).getMobManager().setIgnoreEntity(l.getUniqueId());
                            }
                        }
                    }, 10L);
                } else {
                    l = event.getEntity();
                    Schedulers.sync().runLater(() -> {
                        if (!((MythicBukkit)this.getPlugin()).getMobManager().isActiveMob(l.getUniqueId())) {
                            ((MythicBukkit)this.getPlugin()).getMobManager().setIgnoreEntity(l.getUniqueId());
                        }
                    }, 20L);
                }
            }
        }).bindWith(this);
        Events.subscribe(EntitiesLoadEvent.class, EventPriority.HIGHEST).handler(event -> {
            for (Entity ee : event.getEntities()) {
                MythicMob mm4;
                if (!(ee instanceof LivingEntity) || ee instanceof Player) continue;
                AbstractEntity ae = BukkitAdapter.adapt(ee);
                MythicEntityType met = ((MythicBukkit)this.getPlugin()).getBootstrap().getMythicEntityType(ee);
                Optional<MythicMob> maybeType = ((MythicBukkit)this.getPlugin()).getMobManager().getVanillaType(met);
                if (!maybeType.isPresent() || !(mm4 = maybeType.get()).getMythicEntity().compare(ee)) continue;
                double level = 1.0 + WorldScaling.getLevelBonus(ae.getLocation());
                ActiveMob am = ((MythicBukkit)this.getPlugin()).getMobManager().registerActiveMob(ae, mm4, level);
                mm4.getMythicEntity().applyOptions(ee);
                mm4.applyMobOptions(am, level);
                mm4.applyMobVolatileOptions(am);
                mm4.applySpawnModifiers(am);
            }
        }).bindWith(this);
        Events.subscribe(ChunkLoadEvent.class, EventPriority.HIGHEST).filter(event -> event.isNewChunk()).handler(event -> {
            if (((MythicBukkit)this.getPlugin()).getConfiguration().isDebugMode()) {
                return;
            }
            MythicLogger.debug(MythicLogger.DebugLevel.EVENT, "ChunkLoadEvent (New Chunk) fired", new Object[0]);
            for (Entity entity : event.getChunk().getEntities()) {
                if (entity.getType() == EntityType.PLAYER || ((MythicBukkit)this.getPlugin()).getCompatibility().getWorldGuard().isPresent() && !((MythicBukkit)this.getPlugin()).getCompatibility().getWorldGuard().get().getLocationAllowsMobSpawning(entity.getLocation())) continue;
                AbstractEntity spawn = BukkitAdapter.adapt(entity);
                RandomSpawnPoint rsp = new RandomSpawnPoint(spawn, spawn.getLocation(), CreatureSpawnEvent.SpawnReason.NATURAL);
                Entity ee = BukkitAdapter.adapt(((MythicBukkit)this.getPlugin()).getRandomSpawningManager().handleSpawnEvent(rsp));
                if (ee != null) {
                    entity.remove();
                    continue;
                }
                if (!((MythicBukkit)this.getPlugin()).getConfiguration().isVanillaSpawnsDisabled() || BukkitEntityType.getIsSpawning().booleanValue()) continue;
                entity.remove();
            }
        }).bindWith(this);
        Events.subscribe(EntityTransformEvent.class).handler(event -> {
            ActiveMob am;
            if (((MythicBukkit)this.getPlugin()).getMobManager().isActiveMob(event.getEntity().getUniqueId()) && (am = ((MythicBukkit)this.getPlugin()).getMobManager().getMythicMobInstance(event.getEntity())).getType().getPreventTransformation().booleanValue()) {
                event.setCancelled(true);
            }
        }).bindWith(this);
        Events.subscribe(CreatureSpawnEvent.class, EventPriority.HIGHEST).filter(event -> !event.isCancelled()).filter(event -> event.getSpawnReason() == CreatureSpawnEvent.SpawnReason.BEEHIVE).handler(event -> {
            LivingEntity entity = event.getEntity();
            if (((MythicBukkit)this.getPlugin()).getMobManager().isMythicMob((Entity)entity)) {
                ((MythicBukkit)this.getPlugin()).getMobManager().getMythicMobInstance(BukkitAdapter.adapt((Entity)event.getEntity()));
            }
        }).bindWith(this);
        Events.subscribe(EntityCombustEvent.class, EventPriority.HIGHEST).filter(event -> !event.isCancelled()).filter(event -> !(event instanceof EntityCombustByBlockEvent) && !(event instanceof EntityCombustByEntityEvent)).filter(event -> event.getEntity().getWorld().getEnvironment() == World.Environment.NORMAL).handler(event -> {
            ActiveMob am;
            Entity entity = event.getEntity();
            if (((MythicBukkit)this.getPlugin()).getMobManager().isActiveMob(entity.getUniqueId()) && (am = ((MythicBukkit)this.getPlugin()).getMobManager().getMythicMobInstance(entity)).getType().getPreventSunburn().booleanValue()) {
                event.setDuration(0);
                event.setCancelled(true);
            }
        }).bindWith(this);
        Events.subscribe(EntityDamageEvent.class, EventPriority.LOWEST).filter(event -> !event.isCancelled()).handler(this::damagePassthroughEvent).bindWith(this);
        Events.subscribe(EntityDamageByEntityEvent.class, EventPriority.LOWEST).filter(event -> !event.isCancelled()).handler(this::damagePassthroughEvent).bindWith(this);
        Events.subscribe(EntityDamageByBlockEvent.class, EventPriority.LOWEST).filter(event -> !event.isCancelled()).handler(this::damagePassthroughEvent).bindWith(this);
        Events.subscribe(PlayerInteractEntityEvent.class, EventPriority.HIGH).handler(this::onTagEntity).bindWith(this);
        Events.subscribe(PlayerLeashEntityEvent.class, EventPriority.HIGH).handler(this::onLeashEntity).bindWith(this);
        Events.subscribe(EntityChangeBlockEvent.class, EventPriority.HIGH).handler(this::onChangeBlockEvent).bindWith(this);
        Events.subscribe(EntityBlockFormEvent.class, EventPriority.HIGH).handler(this::onBlockForm).bindWith(this);
        Events.subscribe(EntityTeleportEvent.class, EventPriority.HIGH).handler(this::onTeleportEvent).bindWith(this);
        Events.subscribe(MythicDamageEvent.class, EventPriority.HIGH).filter(event -> !event.isCancelled()).handler(this::onMythicDamage).bindWith(this);
    }

    @Override
    public void unload() {
    }

    public void damagePassthroughEvent(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Damageable)) {
            return;
        }
        Damageable damaged = (Damageable)entity;
        if (!((MythicBukkit)this.getPlugin()).getMobManager().isActiveMob(damaged.getUniqueId())) {
            return;
        }
        ActiveMob am = ((MythicBukkit)this.getPlugin()).getMobManager().getMythicMobInstance((Entity)damaged);
        if (!am.getType().getPassthroughDamage().booleanValue() || !am.getParent().isPresent()) {
            return;
        }
        MythicLogger.debug(MythicLogger.DebugLevel.TRIGGER, "Passing damage to parent", new Object[0]);
        event.setCancelled(true);
        LivingEntity parent = (LivingEntity)am.getParent().get().getBukkitEntity();
        double damage = event.getFinalDamage();
        if (event instanceof EntityDamageByEntityEvent) {
            EntityDamageByEntityEvent entityDamageByEntityEvent = (EntityDamageByEntityEvent)event;
            Entity damager = entityDamageByEntityEvent.getDamager();
            if (damager instanceof Projectile) {
                Projectile projectileEntity = (Projectile)damager;
                MythicLogger.debug(MythicLogger.DebugLevel.INFO, "Damage passed from arrow", new Object[0]);
                ProjectileSource shooter = projectileEntity.getShooter();
                if (shooter instanceof LivingEntity) {
                    parent.damage(damage, (Entity)projectileEntity.getShooter());
                } else {
                    parent.damage(damage);
                }
                damager.remove();
            } else {
                parent.damage(damage, damager);
            }
        } else {
            parent.damage(damage, event.getDamageSource().getCausingEntity());
        }
    }

    public void onTagEntity(PlayerInteractEntityEvent e) {
        if (!(e.getRightClicked() instanceof LivingEntity)) {
            return;
        }
        LivingEntity l = (LivingEntity)e.getRightClicked();
        if (!((MythicBukkit)this.getPlugin()).getMobManager().isActiveMob(l.getUniqueId())) {
            return;
        }
        EntityEquipment ee = e.getPlayer().getEquipment();
        if (ee != null && ee.getItemInMainHand().getType() != Material.NAME_TAG) {
            return;
        }
        ActiveMob am = ((MythicBukkit)this.getPlugin()).getMobManager().getMythicMobInstance((Entity)l);
        if (am.getType().getPreventRename().booleanValue()) {
            e.setCancelled(true);
            e.getPlayer().sendMessage("\u00a7cThis mob can't be renamed");
        } else {
            am.setDespawnMode(DespawnMode.PERSISTENT);
            Schedulers.sync().runLater(() -> am.setDisplayName(l.getName()), 1L);
        }
    }

    public void onLeashEntity(PlayerLeashEntityEvent e) {
        if (!(e.getEntity() instanceof LivingEntity)) {
            return;
        }
        LivingEntity l = (LivingEntity)e.getEntity();
        if (!((MythicBukkit)this.getPlugin()).getMobManager().isActiveMob(l.getUniqueId())) {
            return;
        }
        ActiveMob am = ((MythicBukkit)this.getPlugin()).getMobManager().getMythicMobInstance((Entity)l);
        if (am.getType().getPreventLeashing().booleanValue()) {
            e.setCancelled(true);
            e.getPlayer().sendMessage(String.valueOf(ChatColor.RED) + "That mob can't be leashed!");
        }
    }

    public void onBlockForm(EntityBlockFormEvent e) {
        ActiveMob am;
        if (((MythicBukkit)this.getPlugin()).getMobManager().isActiveMob(e.getEntity().getUniqueId()) && (am = ((MythicBukkit)this.getPlugin()).getMobManager().getMythicMobInstance(e.getEntity())).getType().getMythicEntity() instanceof BukkitSnowman && ((BukkitSnowman)am.getType().getMythicEntity()).getPreventSnowFormation()) {
            e.setCancelled(true);
        }
    }

    public void onTeleportEvent(EntityTeleportEvent e) {
        Entity entity = e.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        ActiveMob am = ((MythicBukkit)this.getPlugin()).getMobManager().getMythicMobInstance(e.getEntity());
        if (am == null) {
            return;
        }
        if (am.getEntity().hasMetadata("teleporting")) {
            return;
        }
        if (am.getType().getPreventEndermanTeleport().booleanValue()) {
            am.getEntity().setMetadata("teleporting", true);
            e.getEntity().teleport(e.getFrom());
            am.getEntity().removeMetadata("teleporting");
            e.setCancelled(true);
        } else {
            SkillMetadata data = ((MythicBukkit)this.getPlugin()).getSkillManager().getEventBus().buildSkillMetadata(SkillTriggers.TELEPORT, am, null, null, false);
            TriggeredSkill ts = ((MythicBukkit)this.getPlugin()).getSkillManager().getEventBus().processTriggerMechanics(data);
            if (ts.getCancelled()) {
                e.setCancelled(true);
            }
        }
    }

    public void onChangeBlockEvent(EntityChangeBlockEvent e) {
        ActiveMob am;
        if (((MythicBukkit)this.getPlugin()).getMobManager().isActiveMob(e.getEntity().getUniqueId()) && (am = ((MythicBukkit)this.getPlugin()).getMobManager().getMythicMobInstance(e.getEntity())).getType().getMythicEntity() instanceof BukkitSilverfish && ((BukkitSilverfish)am.getType().getMythicEntity()).getPreventBlockInfection()) {
            e.setCancelled(true);
            LivingEntity l = (LivingEntity)e.getEntity();
            ActiveMob amN = am.getType().spawn(am.getEntity().getLocation(), am.getLevel(), SpawnReason.OTHER);
            LivingEntity ll = (LivingEntity)BukkitAdapter.adapt(amN.getEntity());
            ll.setMaxHealth(l.getMaxHealth());
            ll.setHealth(l.getHealth());
            if (l.getPassenger() != null) {
                ll.setPassenger(l.getPassenger());
            }
            if (l.getVehicle() != null) {
                l.getVehicle().setPassenger((Entity)ll);
            }
            Collection pe = l.getActivePotionEffects();
            for (PotionEffect p : pe) {
                ll.addPotionEffect(p);
            }
            ActiveMob am2 = ((MythicBukkit)this.getPlugin()).getMobManager().getMythicMobInstance(BukkitAdapter.adapt((Entity)ll));
            if (am2 == null) {
                MythicLogger.debug(MythicLogger.DebugLevel.INFO, "-- Something prevented Silverfish from respawning! PreventBlockInfection failed :(", new Object[0]);
                return;
            }
            am2.setStance(am.getStance());
            am2.importPlayerKills(am.getPlayerKills());
            am2.importThreatTable(am.getThreatTable());
            l.remove();
            am.setDead();
        }
    }

    public void onMythicDamage(MythicDamageEvent e) {
        if (!((MythicBukkit)this.plugin).getVolatileCodeHandler().getEntityHandler().doDamage(e.getDamageMetadata(), e.getTarget())) {
            e.setCancelled(true);
        }
    }
}

