/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.config.properties.types;

import io.lumine.mythic.bukkit.utils.config.properties.PropertyType;
import io.lumine.mythic.bukkit.utils.plugin.LuminePlugin;
import io.lumine.mythic.bukkit.utils.serialize.BlockLocus;
import io.lumine.mythic.bukkit.utils.serialize.BlockOrient;
import io.lumine.mythic.bukkit.utils.serialize.Direction;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;

public class BlockOrientMapProp
extends PropertyType<Map<String, BlockOrient>> {
    public BlockOrientMapProp(LuminePlugin plugin, Object file, String node) {
        super(plugin, file, node);
    }

    @Override
    protected Map<String, BlockOrient> compute(ConfigurationSection section, String node) {
        HashMap<String, BlockOrient> result = new HashMap<String, BlockOrient>();
        if (section == null) {
            return result;
        }
        if ((section = section.getConfigurationSection(node)) == null) {
            return result;
        }
        for (String key : section.getKeys(false)) {
            String prop = section.getString(key);
            try {
                String[] split = prop.split(",");
                int x = Integer.valueOf(split[0]);
                int y = Integer.valueOf(split[1]);
                int z = Integer.valueOf(split[2]);
                float yaw = Float.valueOf(split[3]).floatValue();
                float pitch = Float.valueOf(split[4]).floatValue();
                result.put(key, BlockOrient.of(BlockLocus.of(x, y, z), Direction.of(yaw, pitch)));
            }
            catch (Error | Exception ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    @Override
    protected Map<String, BlockOrient> getDefaultValue() {
        return Collections.emptyMap();
    }

    @Override
    public void set(String holder, Map<String, BlockOrient> value) {
        if (this.config == null) {
            return;
        }
        ArrayList<CallSite> out = new ArrayList<CallSite>();
        for (Map.Entry<String, BlockOrient> entry : value.entrySet()) {
            BlockOrient orient = entry.getValue();
            String o = entry.getKey() + " " + orient.getLocus().getX() + "," + orient.getLocus().getY() + "," + orient.getLocus().getZ() + "," + orient.getDirection().getYaw() + "," + orient.getDirection().getPitch();
            out.add((CallSite)((Object)o));
        }
        this.config.set(this.node, out);
    }
}

