/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.config.properties.types;

import io.lumine.mythic.bukkit.utils.config.properties.PropertyType;
import io.lumine.mythic.bukkit.utils.config.properties.types.DoubleProp;
import io.lumine.mythic.bukkit.utils.config.properties.types.PositionProp;
import io.lumine.mythic.bukkit.utils.plugin.LuminePlugin;
import io.lumine.mythic.bukkit.utils.serialize.CircularRegion;
import io.lumine.mythic.bukkit.utils.serialize.Position;
import org.bukkit.configuration.ConfigurationSection;

public class CircularRegionProp
extends PropertyType<CircularRegion> {
    private final PositionProp center;
    private final DoubleProp radius;

    public CircularRegionProp(LuminePlugin plugin, Object file, String node) {
        super(plugin, file, node);
        this.center = new PositionProp(plugin, file, node + ".Center");
        this.radius = new DoubleProp(plugin, file, node + ".Radius");
    }

    public CircularRegionProp(LuminePlugin plugin, Object file, String node, CircularRegion defaultValue) {
        super(plugin, file, node);
        this.center = new PositionProp(plugin, file, node + ".Center", defaultValue.getCenter());
        this.radius = new DoubleProp(plugin, file, node + ".Radius", defaultValue.getRadius());
    }

    @Override
    protected CircularRegion compute(ConfigurationSection section, String node) {
        return CircularRegion.of((Position)this.center.get(section), (Double)this.radius.get(section));
    }

    @Override
    protected CircularRegion getDefaultValue() {
        return CircularRegion.of(this.center.getDefaultValue(), this.radius.getDefaultValue());
    }

    @Override
    public void set(String holder, CircularRegion value) {
        if (this.config == null) {
            return;
        }
        this.center.set(holder, value.getCenter());
        this.radius.set(holder, Double.valueOf(value.getRadius()));
    }
}

