/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.config.properties.types;

import io.lumine.mythic.bukkit.utils.config.properties.PropertyType;
import io.lumine.mythic.bukkit.utils.config.properties.types.DoubleProp;
import io.lumine.mythic.bukkit.utils.config.properties.types.LocProp;
import io.lumine.mythic.bukkit.utils.plugin.LuminePlugin;
import io.lumine.mythic.bukkit.utils.serialize.CircularZone;
import io.lumine.mythic.bukkit.utils.serialize.Locus;
import org.bukkit.configuration.ConfigurationSection;

public class CircularZoneProp
extends PropertyType<CircularZone> {
    private final LocProp center;
    private final DoubleProp radius;

    public CircularZoneProp(LuminePlugin plugin, Object file, String node) {
        super(plugin, file, node);
        this.center = new LocProp(plugin, file, node + ".Center");
        this.radius = new DoubleProp(plugin, file, node + ".Radius");
    }

    public CircularZoneProp(LuminePlugin plugin, Object file, String node, CircularZone defaultValue) {
        super(plugin, file, node);
        this.center = new LocProp(plugin, file, node + ".Center", defaultValue.getCenter());
        this.radius = new DoubleProp(plugin, file, node + ".Radius", defaultValue.getRadius());
    }

    @Override
    protected CircularZone compute(ConfigurationSection section, String node) {
        return CircularZone.of((Locus)this.center.get(section), (Double)this.radius.get(section));
    }

    @Override
    protected CircularZone getDefaultValue() {
        return CircularZone.of(this.center.getDefaultValue(), this.radius.getDefaultValue());
    }

    @Override
    public void set(String holder, CircularZone value) {
        if (this.config == null) {
            return;
        }
        this.center.set(holder, value.getCenter());
        this.radius.set(holder, Double.valueOf(value.getRadius()));
    }
}

