/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.events.functional.protocol;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketEvent;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.lumine.mythic.bukkit.utils.Delegates;
import io.lumine.mythic.bukkit.utils.events.ProtocolSubscription;
import io.lumine.mythic.bukkit.utils.events.functional.ExpiryTestStage;
import io.lumine.mythic.bukkit.utils.events.functional.SubscriptionBuilder;
import io.lumine.mythic.bukkit.utils.events.functional.protocol.ProtocolHandlerList;
import io.lumine.mythic.bukkit.utils.events.functional.protocol.ProtocolSubscriptionBuilderImpl;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public interface ProtocolSubscriptionBuilder
extends SubscriptionBuilder<PacketEvent> {
    @Nonnull
    public static ProtocolSubscriptionBuilder newBuilder(PacketType ... packets) {
        return ProtocolSubscriptionBuilder.newBuilder(ListenerPriority.NORMAL, packets);
    }

    @Nonnull
    public static ProtocolSubscriptionBuilder newBuilder(@Nonnull ListenerPriority priority, PacketType ... packets) {
        Objects.requireNonNull(priority, "priority");
        Objects.requireNonNull(packets, "packets");
        return new ProtocolSubscriptionBuilderImpl((Set<PacketType>)ImmutableSet.copyOf((Object[])packets), priority);
    }

    @Nonnull
    default public ProtocolSubscriptionBuilder expireIf(@Nonnull Predicate<PacketEvent> predicate) {
        return this.expireIf(Delegates.predicateToBiPredicateSecond(predicate), ExpiryTestStage.PRE, ExpiryTestStage.POST_HANDLE);
    }

    @Nonnull
    default public ProtocolSubscriptionBuilder expireAfter(long duration, @Nonnull TimeUnit unit) {
        Objects.requireNonNull(unit, "unit");
        Preconditions.checkArgument((duration >= 1L ? 1 : 0) != 0, (Object)"duration < 1");
        long expiry = Math.addExact(System.currentTimeMillis(), unit.toMillis(duration));
        return this.expireIf((handler, event) -> System.currentTimeMillis() > expiry, ExpiryTestStage.PRE);
    }

    @Nonnull
    default public ProtocolSubscriptionBuilder expireAfter(long maxCalls) {
        Preconditions.checkArgument((maxCalls >= 1L ? 1 : 0) != 0, (Object)"maxCalls < 1");
        return this.expireIf((handler, event) -> handler.getCallCounter() >= maxCalls, ExpiryTestStage.PRE, ExpiryTestStage.POST_HANDLE);
    }

    @Nonnull
    public ProtocolSubscriptionBuilder filter(@Nonnull Predicate<PacketEvent> var1);

    @Nonnull
    public ProtocolSubscriptionBuilder expireIf(@Nonnull BiPredicate<ProtocolSubscription, PacketEvent> var1, ExpiryTestStage ... var2);

    @Nonnull
    public ProtocolSubscriptionBuilder exceptionConsumer(@Nonnull BiConsumer<? super PacketEvent, Throwable> var1);

    @Nonnull
    public ProtocolHandlerList handlers();

    @Nonnull
    default public ProtocolSubscription handler(@Nonnull Consumer<? super PacketEvent> handler) {
        return (ProtocolSubscription)this.handlers().consumer((Consumer)handler).register();
    }

    @Nonnull
    default public ProtocolSubscription biHandler(@Nonnull BiConsumer<ProtocolSubscription, ? super PacketEvent> handler) {
        return (ProtocolSubscription)this.handlers().biConsumer((BiConsumer)handler).register();
    }
}

