/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.http.impl.execchain;

import io.lumine.mythic.bukkit.utils.lib.http.HttpException;
import io.lumine.mythic.bukkit.utils.lib.http.HttpResponse;
import io.lumine.mythic.bukkit.utils.lib.http.annotation.Immutable;
import io.lumine.mythic.bukkit.utils.lib.http.client.BackoffManager;
import io.lumine.mythic.bukkit.utils.lib.http.client.ConnectionBackoffStrategy;
import io.lumine.mythic.bukkit.utils.lib.http.client.methods.CloseableHttpResponse;
import io.lumine.mythic.bukkit.utils.lib.http.client.methods.HttpExecutionAware;
import io.lumine.mythic.bukkit.utils.lib.http.client.methods.HttpRequestWrapper;
import io.lumine.mythic.bukkit.utils.lib.http.client.protocol.HttpClientContext;
import io.lumine.mythic.bukkit.utils.lib.http.conn.routing.HttpRoute;
import io.lumine.mythic.bukkit.utils.lib.http.impl.execchain.ClientExecChain;
import io.lumine.mythic.bukkit.utils.lib.http.util.Args;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;

@Immutable
public class BackoffStrategyExec
implements ClientExecChain {
    private final ClientExecChain requestExecutor;
    private final ConnectionBackoffStrategy connectionBackoffStrategy;
    private final BackoffManager backoffManager;

    public BackoffStrategyExec(ClientExecChain requestExecutor, ConnectionBackoffStrategy connectionBackoffStrategy, BackoffManager backoffManager) {
        Args.notNull(requestExecutor, "HTTP client request executor");
        Args.notNull(connectionBackoffStrategy, "Connection backoff strategy");
        Args.notNull(backoffManager, "Backoff manager");
        this.requestExecutor = requestExecutor;
        this.connectionBackoffStrategy = connectionBackoffStrategy;
        this.backoffManager = backoffManager;
    }

    @Override
    public CloseableHttpResponse execute(HttpRoute route, HttpRequestWrapper request, HttpClientContext context, HttpExecutionAware execAware) throws IOException, HttpException {
        Args.notNull(route, "HTTP route");
        Args.notNull(request, "HTTP request");
        Args.notNull(context, "HTTP context");
        Closeable out = null;
        try {
            out = this.requestExecutor.execute(route, request, context, execAware);
        }
        catch (Exception ex) {
            if (out != null) {
                out.close();
            }
            if (this.connectionBackoffStrategy.shouldBackoff(ex)) {
                this.backoffManager.backOff(route);
            }
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            if (ex instanceof HttpException) {
                throw (HttpException)ex;
            }
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            throw new UndeclaredThrowableException(ex);
        }
        if (this.connectionBackoffStrategy.shouldBackoff((HttpResponse)((Object)out))) {
            this.backoffManager.backOff(route);
        } else {
            this.backoffManager.probe(route);
        }
        return out;
    }
}

