/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.Context;
import io.lumine.mythic.bukkit.utils.lib.jooq.DatePart;
import io.lumine.mythic.bukkit.utils.lib.jooq.Field;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractField;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DSL;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Names;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.QOM;

final class TruncDate<T>
extends AbstractField<T>
implements QOM.UNotYetImplemented {
    private final Field<T> date;
    private final DatePart part;

    TruncDate(Field<T> date, DatePart part) {
        super(Names.N_TRUNC, date.getDataType());
        this.date = date;
        this.part = part;
    }

    @Override
    public final void accept(Context<?> ctx) {
        String keyword = null;
        String format = null;
        switch (ctx.family()) {
            case CUBRID: 
            case HSQLDB: {
                switch (this.part) {
                    case YEAR: {
                        keyword = "YY";
                        break;
                    }
                    case MONTH: {
                        keyword = "MM";
                        break;
                    }
                    case DAY: {
                        keyword = "DD";
                        break;
                    }
                    case HOUR: {
                        keyword = "HH";
                        break;
                    }
                    case MINUTE: {
                        keyword = "MI";
                        break;
                    }
                    case SECOND: {
                        keyword = "SS";
                        break;
                    }
                    default: {
                        this.throwUnsupported();
                    }
                }
                ctx.visit(Names.N_TRUNC).sql('(').visit(this.date).sql(", ").visit(DSL.inline(keyword)).sql(')');
                break;
            }
            case H2: {
                switch (this.part) {
                    case YEAR: {
                        format = "yyyy";
                        break;
                    }
                    case MONTH: {
                        format = "yyyy-MM";
                        break;
                    }
                    case DAY: {
                        format = "yyyy-MM-dd";
                        break;
                    }
                    case HOUR: {
                        format = "yyyy-MM-dd HH";
                        break;
                    }
                    case MINUTE: {
                        format = "yyyy-MM-dd HH:mm";
                        break;
                    }
                    case SECOND: {
                        format = "yyyy-MM-dd HH:mm:ss";
                        break;
                    }
                    default: {
                        this.throwUnsupported();
                    }
                }
                ctx.visit(DSL.keyword("parsedatetime")).sql('(').visit(DSL.keyword("formatdatetime")).sql('(').visit(this.date).sql(", ").visit(DSL.inline(format)).sql("), ").visit(DSL.inline(format)).sql(')');
                break;
            }
            case POSTGRES: 
            case YUGABYTEDB: {
                switch (this.part) {
                    case YEAR: {
                        keyword = "year";
                        break;
                    }
                    case MONTH: {
                        keyword = "month";
                        break;
                    }
                    case DAY: {
                        keyword = "day";
                        break;
                    }
                    case HOUR: {
                        keyword = "hour";
                        break;
                    }
                    case MINUTE: {
                        keyword = "minute";
                        break;
                    }
                    case SECOND: {
                        keyword = "second";
                        break;
                    }
                    default: {
                        this.throwUnsupported();
                    }
                }
                ctx.visit(Names.N_DATE_TRUNC).sql('(').visit(DSL.inline(keyword)).sql(", ").visit(this.date).sql(')');
                break;
            }
            default: {
                ctx.visit(Names.N_TRUNC).sql('(').visit(this.date).sql(", ").visit(DSL.inline(keyword)).sql(')');
            }
        }
    }

    private final void throwUnsupported() {
        throw new UnsupportedOperationException("Unknown date part : " + this.part);
    }
}

