/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.math3.genetics;

import io.lumine.mythic.bukkit.utils.lib.math3.exception.MathIllegalArgumentException;
import io.lumine.mythic.bukkit.utils.lib.math3.exception.util.LocalizedFormats;
import io.lumine.mythic.bukkit.utils.lib.math3.genetics.AbstractListChromosome;
import io.lumine.mythic.bukkit.utils.lib.math3.genetics.BinaryChromosome;
import io.lumine.mythic.bukkit.utils.lib.math3.genetics.Chromosome;
import io.lumine.mythic.bukkit.utils.lib.math3.genetics.GeneticAlgorithm;
import io.lumine.mythic.bukkit.utils.lib.math3.genetics.MutationPolicy;
import java.util.ArrayList;

public class BinaryMutation
implements MutationPolicy {
    public Chromosome mutate(Chromosome original) throws MathIllegalArgumentException {
        if (!(original instanceof BinaryChromosome)) {
            throw new MathIllegalArgumentException(LocalizedFormats.INVALID_BINARY_CHROMOSOME, new Object[0]);
        }
        BinaryChromosome origChrom = (BinaryChromosome)original;
        ArrayList newRepr = new ArrayList(origChrom.getRepresentation());
        int geneIndex = GeneticAlgorithm.getRandomGenerator().nextInt(origChrom.getLength());
        newRepr.set(geneIndex, (Integer)origChrom.getRepresentation().get(geneIndex) == 0 ? 1 : 0);
        AbstractListChromosome newChrom = origChrom.newFixedLengthChromosome(newRepr);
        return newChrom;
    }
}

