/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.menu;

import io.lumine.mythic.bukkit.utils.items.ItemFactory;
import io.lumine.mythic.bukkit.utils.menu.Icon;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class IconBuilder<T> {
    private BiFunction<T, Player, ItemFactory> iconFunc;
    private BiFunction<T, Player, ItemFactory> blinkFunc;
    private BiFunction<T, Player, Material> materialFunc;
    private BiFunction<T, Player, NamespacedKey> itemModelFunc;
    private BiFunction<T, Player, Integer> modelFunc;
    private BiFunction<T, Player, String> nameFunc;
    private BiFunction<T, Player, List<String>> loreFunc;
    private BiFunction<T, Player, Integer> amountFunc;
    private BiConsumer<T, Player> clickFunc;
    private BiConsumer<T, Player> rightClickFunc;
    private BiConsumer<T, Player> shiftClickFunc;
    private BiConsumer<T, Player> shiftRightClickFunc;
    private BiConsumer<T, Player> doubleClickFunc;
    private BiConsumer<T, Player> dropClickFunc;
    private BiConsumer<T, Player> dropAllClickFunc;
    private BiConsumer<T, Player> middleClickFunc;
    private BiConsumer<T, Player> swapOffhandClickFunc;
    private boolean hideFlags = false;

    public static <T> IconBuilder<T> create() {
        return new IconBuilder<T>();
    }

    private IconBuilder() {
    }

    public IconBuilder<T> item(ItemFactory itemStack) {
        this.iconFunc = (_state, player) -> itemStack;
        return this;
    }

    public IconBuilder<T> item(Function<T, ItemFactory> materialFunc) {
        this.iconFunc = (_state, player) -> (ItemFactory)materialFunc.apply(_state);
        return this;
    }

    public IconBuilder<T> item(BiFunction<T, Player, ItemFactory> materialFunc) {
        this.iconFunc = materialFunc;
        return this;
    }

    public IconBuilder<T> itemStack(ItemStack itemStack) {
        this.iconFunc = (_state, player) -> ItemFactory.of(itemStack);
        return this;
    }

    public IconBuilder<T> itemStack(Function<T, ItemStack> materialFunc) {
        this.iconFunc = (_state, player) -> ItemFactory.of((ItemStack)materialFunc.apply(_state));
        return this;
    }

    public IconBuilder<T> itemStack(BiFunction<T, Player, ItemStack> materialFunc) {
        this.iconFunc = (_state, player) -> ItemFactory.of((ItemStack)materialFunc.apply((Object)_state, (Player)player));
        return this;
    }

    public IconBuilder<T> blink(Function<T, ItemFactory> materialFunc) {
        this.blinkFunc = (_state, player) -> (ItemFactory)materialFunc.apply(_state);
        return this;
    }

    public IconBuilder<T> blink(BiFunction<T, Player, ItemFactory> materialFunc) {
        this.blinkFunc = materialFunc;
        return this;
    }

    public IconBuilder<T> blinkStack(Function<T, ItemStack> materialFunc) {
        this.blinkFunc = (_state, player) -> ItemFactory.of((ItemStack)materialFunc.apply(_state));
        return this;
    }

    public IconBuilder<T> blinkStack(BiFunction<T, Player, ItemStack> materialFunc) {
        this.blinkFunc = (_state, player) -> ItemFactory.of((ItemStack)materialFunc.apply((Object)_state, (Player)player));
        return this;
    }

    public IconBuilder<T> material(Material material) {
        this.materialFunc = (_state, player) -> material;
        return this;
    }

    public IconBuilder<T> material(Function<T, Material> materialFunc) {
        this.materialFunc = (_state, player) -> (Material)materialFunc.apply(_state);
        return this;
    }

    public IconBuilder<T> name(String name) {
        this.nameFunc = (_state, player) -> name;
        return this;
    }

    public IconBuilder<T> name(Function<T, String> nameFunc) {
        this.nameFunc = (_state, player) -> (String)nameFunc.apply(_state);
        return this;
    }

    public IconBuilder<T> lore(List<String> lore) {
        this.loreFunc = (_state, player) -> lore;
        return this;
    }

    public IconBuilder<T> lore(Function<T, List<String>> loreFunc) {
        this.loreFunc = (_state, player) -> (List)loreFunc.apply(_state);
        return this;
    }

    public IconBuilder<T> click(BiConsumer<T, Player> clickFunc) {
        this.clickFunc = clickFunc;
        return this;
    }

    public IconBuilder<T> rightClick(BiConsumer<T, Player> clickFunc) {
        this.rightClickFunc = clickFunc;
        return this;
    }

    public IconBuilder<T> shiftClick(BiConsumer<T, Player> clickFunc) {
        this.shiftClickFunc = clickFunc;
        return this;
    }

    public IconBuilder<T> shiftRightClick(BiConsumer<T, Player> clickFunc) {
        this.shiftRightClickFunc = clickFunc;
        return this;
    }

    public IconBuilder<T> doubleClick(BiConsumer<T, Player> clickFunc) {
        this.doubleClickFunc = clickFunc;
        return this;
    }

    public IconBuilder<T> dropClick(BiConsumer<T, Player> clickFunc) {
        this.dropClickFunc = clickFunc;
        return this;
    }

    public IconBuilder<T> dropAllClick(BiConsumer<T, Player> clickFunc) {
        this.dropAllClickFunc = clickFunc;
        return this;
    }

    public IconBuilder<T> middleClick(BiConsumer<T, Player> clickFunc) {
        this.middleClickFunc = clickFunc;
        return this;
    }

    public IconBuilder<T> swapOffhandClick(BiConsumer<T, Player> clickFunc) {
        this.swapOffhandClickFunc = clickFunc;
        return this;
    }

    @Deprecated
    public IconBuilder<T> data(Byte data) {
        return this;
    }

    @Deprecated
    public IconBuilder<T> data(Function<T, Byte> dataFunc) {
        return this;
    }

    public IconBuilder<T> model(int data) {
        this.modelFunc = (_state, player) -> data;
        return this;
    }

    public IconBuilder<T> model(Function<T, Integer> dataFunc) {
        this.modelFunc = (_state, player) -> (Integer)dataFunc.apply(_state);
        return this;
    }

    public IconBuilder<T> itemModel(NamespacedKey data) {
        this.itemModelFunc = (_state, player) -> data;
        return this;
    }

    public IconBuilder<T> itemModel(Function<T, NamespacedKey> dataFunc) {
        this.itemModelFunc = (_state, player) -> (NamespacedKey)dataFunc.apply(_state);
        return this;
    }

    public IconBuilder<T> amount(int data) {
        this.amountFunc = (_state, player) -> data;
        return this;
    }

    public IconBuilder<T> amount(Function<T, Integer> amountFunc) {
        this.amountFunc = (_state, player) -> (Integer)amountFunc.apply(_state);
        return this;
    }

    public IconBuilder<T> hideFlags() {
        this.hideFlags = true;
        return this;
    }

    public IconBuilder<T> hideFlags(boolean bool) {
        this.hideFlags = bool;
        return this;
    }

    public Icon<T> build() {
        if (this.iconFunc == null && this.materialFunc == null) {
            throw new IllegalStateException("Material must be specified!");
        }
        return new Icon<T>(this.iconFunc, this.materialFunc, this.itemModelFunc, this.nameFunc, this.loreFunc, this.clickFunc, this.rightClickFunc, this.modelFunc, this.amountFunc, this.blinkFunc, this.hideFlags, this.shiftClickFunc, this.shiftRightClickFunc, this.doubleClickFunc, this.dropClickFunc, this.dropAllClickFunc, this.middleClickFunc, this.swapOffhandClickFunc);
    }
}

